<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dialogflow;

class GoogleCloudDialogflowCxV3beta1ResponseMessage extends \Google\Model
{
  /**
   * The channel which the response is associated with. Clients can specify the
   * channel via QueryParameters.channel, and only associated channel response
   * will be returned.
   *
   * @var string
   */
  public $channel;
  protected $conversationSuccessType = GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess::class;
  protected $conversationSuccessDataType = '';
  protected $endInteractionType = GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction::class;
  protected $endInteractionDataType = '';
  protected $knowledgeInfoCardType = GoogleCloudDialogflowCxV3beta1ResponseMessageKnowledgeInfoCard::class;
  protected $knowledgeInfoCardDataType = '';
  protected $liveAgentHandoffType = GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff::class;
  protected $liveAgentHandoffDataType = '';
  protected $mixedAudioType = GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio::class;
  protected $mixedAudioDataType = '';
  protected $outputAudioTextType = GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText::class;
  protected $outputAudioTextDataType = '';
  /**
   * Returns a response containing a custom, platform-specific payload.
   *
   * @var array[]
   */
  public $payload;
  protected $playAudioType = GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio::class;
  protected $playAudioDataType = '';
  protected $telephonyTransferCallType = GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall::class;
  protected $telephonyTransferCallDataType = '';
  protected $textType = GoogleCloudDialogflowCxV3beta1ResponseMessageText::class;
  protected $textDataType = '';
  protected $toolCallType = GoogleCloudDialogflowCxV3beta1ToolCall::class;
  protected $toolCallDataType = '';

  /**
   * The channel which the response is associated with. Clients can specify the
   * channel via QueryParameters.channel, and only associated channel response
   * will be returned.
   *
   * @param string $channel
   */
  public function setChannel($channel)
  {
    $this->channel = $channel;
  }
  /**
   * @return string
   */
  public function getChannel()
  {
    return $this->channel;
  }
  /**
   * Indicates that the conversation succeeded.
   *
   * @param GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess $conversationSuccess
   */
  public function setConversationSuccess(GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess $conversationSuccess)
  {
    $this->conversationSuccess = $conversationSuccess;
  }
  /**
   * @return GoogleCloudDialogflowCxV3beta1ResponseMessageConversationSuccess
   */
  public function getConversationSuccess()
  {
    return $this->conversationSuccess;
  }
  /**
   * Output only. A signal that indicates the interaction with the Dialogflow
   * agent has ended. This message is generated by Dialogflow only when the
   * conversation reaches `END_SESSION` page. It is not supposed to be defined
   * by the user. It's guaranteed that there is at most one such message in each
   * response.
   *
   * @param GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction $endInteraction
   */
  public function setEndInteraction(GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction $endInteraction)
  {
    $this->endInteraction = $endInteraction;
  }
  /**
   * @return GoogleCloudDialogflowCxV3beta1ResponseMessageEndInteraction
   */
  public function getEndInteraction()
  {
    return $this->endInteraction;
  }
  /**
   * Represents info card for knowledge answers, to be better rendered in
   * Dialogflow Messenger.
   *
   * @param GoogleCloudDialogflowCxV3beta1ResponseMessageKnowledgeInfoCard $knowledgeInfoCard
   */
  public function setKnowledgeInfoCard(GoogleCloudDialogflowCxV3beta1ResponseMessageKnowledgeInfoCard $knowledgeInfoCard)
  {
    $this->knowledgeInfoCard = $knowledgeInfoCard;
  }
  /**
   * @return GoogleCloudDialogflowCxV3beta1ResponseMessageKnowledgeInfoCard
   */
  public function getKnowledgeInfoCard()
  {
    return $this->knowledgeInfoCard;
  }
  /**
   * Hands off conversation to a human agent.
   *
   * @param GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff $liveAgentHandoff
   */
  public function setLiveAgentHandoff(GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff $liveAgentHandoff)
  {
    $this->liveAgentHandoff = $liveAgentHandoff;
  }
  /**
   * @return GoogleCloudDialogflowCxV3beta1ResponseMessageLiveAgentHandoff
   */
  public function getLiveAgentHandoff()
  {
    return $this->liveAgentHandoff;
  }
  /**
   * Output only. An audio response message composed of both the synthesized
   * Dialogflow agent responses and responses defined via play_audio. This
   * message is generated by Dialogflow only and not supposed to be defined by
   * the user.
   *
   * @param GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio $mixedAudio
   */
  public function setMixedAudio(GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio $mixedAudio)
  {
    $this->mixedAudio = $mixedAudio;
  }
  /**
   * @return GoogleCloudDialogflowCxV3beta1ResponseMessageMixedAudio
   */
  public function getMixedAudio()
  {
    return $this->mixedAudio;
  }
  /**
   * A text or ssml response that is preferentially used for TTS output audio
   * synthesis, as described in the comment on the ResponseMessage message.
   *
   * @param GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText $outputAudioText
   */
  public function setOutputAudioText(GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText $outputAudioText)
  {
    $this->outputAudioText = $outputAudioText;
  }
  /**
   * @return GoogleCloudDialogflowCxV3beta1ResponseMessageOutputAudioText
   */
  public function getOutputAudioText()
  {
    return $this->outputAudioText;
  }
  /**
   * Returns a response containing a custom, platform-specific payload.
   *
   * @param array[] $payload
   */
  public function setPayload($payload)
  {
    $this->payload = $payload;
  }
  /**
   * @return array[]
   */
  public function getPayload()
  {
    return $this->payload;
  }
  /**
   * Signal that the client should play an audio clip hosted at a client-
   * specific URI. Dialogflow uses this to construct mixed_audio. However,
   * Dialogflow itself does not try to read or process the URI in any way.
   *
   * @param GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio $playAudio
   */
  public function setPlayAudio(GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio $playAudio)
  {
    $this->playAudio = $playAudio;
  }
  /**
   * @return GoogleCloudDialogflowCxV3beta1ResponseMessagePlayAudio
   */
  public function getPlayAudio()
  {
    return $this->playAudio;
  }
  /**
   * A signal that the client should transfer the phone call connected to this
   * agent to a third-party endpoint.
   *
   * @param GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall $telephonyTransferCall
   */
  public function setTelephonyTransferCall(GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall $telephonyTransferCall)
  {
    $this->telephonyTransferCall = $telephonyTransferCall;
  }
  /**
   * @return GoogleCloudDialogflowCxV3beta1ResponseMessageTelephonyTransferCall
   */
  public function getTelephonyTransferCall()
  {
    return $this->telephonyTransferCall;
  }
  /**
   * Returns a text response.
   *
   * @param GoogleCloudDialogflowCxV3beta1ResponseMessageText $text
   */
  public function setText(GoogleCloudDialogflowCxV3beta1ResponseMessageText $text)
  {
    $this->text = $text;
  }
  /**
   * @return GoogleCloudDialogflowCxV3beta1ResponseMessageText
   */
  public function getText()
  {
    return $this->text;
  }
  /**
   * Returns the definition of a tool call that should be executed by the
   * client.
   *
   * @param GoogleCloudDialogflowCxV3beta1ToolCall $toolCall
   */
  public function setToolCall(GoogleCloudDialogflowCxV3beta1ToolCall $toolCall)
  {
    $this->toolCall = $toolCall;
  }
  /**
   * @return GoogleCloudDialogflowCxV3beta1ToolCall
   */
  public function getToolCall()
  {
    return $this->toolCall;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDialogflowCxV3beta1ResponseMessage::class, 'Google_Service_Dialogflow_GoogleCloudDialogflowCxV3beta1ResponseMessage');
