<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class ImageRawDisk extends \Google\Model
{
  public const CONTAINER_TYPE_TAR = 'TAR';
  /**
   * The format used to encode and transmit the block device, which should
   * beTAR. This is just a container and transmission format and not a runtime
   * format. Provided by the client when the disk image is created.
   *
   * @var string
   */
  public $containerType;
  /**
   * [Deprecated] This field is deprecated. An optional SHA1 checksum of the
   * disk image before unpackaging provided by the client when the disk image is
   * created.
   *
   * @deprecated
   * @var string
   */
  public $sha1Checksum;
  /**
   * The full Google Cloud Storage URL where the raw disk image archive is
   * stored. The following are valid formats for the URL:        -
   * https://storage.googleapis.com/bucket_name/image_archive_name    -
   * https://storage.googleapis.com/bucket_name/folder_name/image_archive_name
   *
   * In order to create an image, you must provide the full or partial URL of
   * one of the following:        - The rawDisk.source URL     - The sourceDisk
   * URL     - The sourceImage URL     - The sourceSnapshot URL
   *
   * @var string
   */
  public $source;

  /**
   * The format used to encode and transmit the block device, which should
   * beTAR. This is just a container and transmission format and not a runtime
   * format. Provided by the client when the disk image is created.
   *
   * Accepted values: TAR
   *
   * @param self::CONTAINER_TYPE_* $containerType
   */
  public function setContainerType($containerType)
  {
    $this->containerType = $containerType;
  }
  /**
   * @return self::CONTAINER_TYPE_*
   */
  public function getContainerType()
  {
    return $this->containerType;
  }
  /**
   * [Deprecated] This field is deprecated. An optional SHA1 checksum of the
   * disk image before unpackaging provided by the client when the disk image is
   * created.
   *
   * @deprecated
   * @param string $sha1Checksum
   */
  public function setSha1Checksum($sha1Checksum)
  {
    $this->sha1Checksum = $sha1Checksum;
  }
  /**
   * @deprecated
   * @return string
   */
  public function getSha1Checksum()
  {
    return $this->sha1Checksum;
  }
  /**
   * The full Google Cloud Storage URL where the raw disk image archive is
   * stored. The following are valid formats for the URL:        -
   * https://storage.googleapis.com/bucket_name/image_archive_name    -
   * https://storage.googleapis.com/bucket_name/folder_name/image_archive_name
   *
   * In order to create an image, you must provide the full or partial URL of
   * one of the following:        - The rawDisk.source URL     - The sourceDisk
   * URL     - The sourceImage URL     - The sourceSnapshot URL
   *
   * @param string $source
   */
  public function setSource($source)
  {
    $this->source = $source;
  }
  /**
   * @return string
   */
  public function getSource()
  {
    return $this->source;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ImageRawDisk::class, 'Google_Service_Compute_ImageRawDisk');
