<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Compute;

class Disk extends \Google\Collection
{
  /**
   * The AccessMode means the disk can be attached to multiple instances in RO
   * mode.
   */
  public const ACCESS_MODE_READ_ONLY_MANY = 'READ_ONLY_MANY';
  /**
   * The AccessMode means the disk can be attached to multiple instances in RW
   * mode.
   */
  public const ACCESS_MODE_READ_WRITE_MANY = 'READ_WRITE_MANY';
  /**
   * The default AccessMode, means the disk can be attached to single instance
   * in RW mode.
   */
  public const ACCESS_MODE_READ_WRITE_SINGLE = 'READ_WRITE_SINGLE';
  /**
   * Default value indicating Architecture is not set.
   */
  public const ARCHITECTURE_ARCHITECTURE_UNSPECIFIED = 'ARCHITECTURE_UNSPECIFIED';
  /**
   * Machines with architecture ARM64
   */
  public const ARCHITECTURE_ARM64 = 'ARM64';
  /**
   * Machines with architecture X86_64
   */
  public const ARCHITECTURE_X86_64 = 'X86_64';
  /**
   * Disk is provisioning
   */
  public const STATUS_CREATING = 'CREATING';
  /**
   * Disk is deleting.
   */
  public const STATUS_DELETING = 'DELETING';
  /**
   * Disk creation failed.
   */
  public const STATUS_FAILED = 'FAILED';
  /**
   * Disk is ready for use.
   */
  public const STATUS_READY = 'READY';
  /**
   * Source data is being copied into the disk.
   */
  public const STATUS_RESTORING = 'RESTORING';
  /**
   * Disk is currently unavailable and cannot be accessed, attached or detached.
   */
  public const STATUS_UNAVAILABLE = 'UNAVAILABLE';
  protected $collection_key = 'users';
  /**
   * The access mode of the disk.              - READ_WRITE_SINGLE: The default
   * AccessMode, means the      disk can be attached to single instance in RW
   * mode.      - READ_WRITE_MANY: The AccessMode means the disk can be
   * attached to multiple instances in RW mode.      - READ_ONLY_MANY: The
   * AccessMode means the disk can be      attached to multiple instances in RO
   * mode.
   *
   * The AccessMode is only valid for Hyperdisk disk types.
   *
   * @var string
   */
  public $accessMode;
  /**
   * The architecture of the disk. Valid values are ARM64 or X86_64.
   *
   * @var string
   */
  public $architecture;
  protected $asyncPrimaryDiskType = DiskAsyncReplication::class;
  protected $asyncPrimaryDiskDataType = '';
  protected $asyncSecondaryDisksType = DiskAsyncReplicationList::class;
  protected $asyncSecondaryDisksDataType = 'map';
  /**
   * Output only. [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @var string
   */
  public $creationTimestamp;
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @var string
   */
  public $description;
  protected $diskEncryptionKeyType = CustomerEncryptionKey::class;
  protected $diskEncryptionKeyDataType = '';
  /**
   * Whether this disk is using confidential compute mode.
   *
   * @var bool
   */
  public $enableConfidentialCompute;
  protected $guestOsFeaturesType = GuestOsFeature::class;
  protected $guestOsFeaturesDataType = 'array';
  /**
   * Output only. [Output Only] The unique identifier for the resource. This
   * identifier is defined by the server.
   *
   * @var string
   */
  public $id;
  /**
   * Output only. [Output Only] Type of the resource. Always compute#disk for
   * disks.
   *
   * @var string
   */
  public $kind;
  /**
   * A fingerprint for the labels being applied to this disk, which is
   * essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a disk.
   *
   * @var string
   */
  public $labelFingerprint;
  /**
   * Labels to apply to this disk. These can be later modified by the setLabels
   * method.
   *
   * @var string[]
   */
  public $labels;
  /**
   * Output only. [Output Only] Last attach timestamp inRFC3339 text format.
   *
   * @var string
   */
  public $lastAttachTimestamp;
  /**
   * Output only. [Output Only] Last detach timestamp inRFC3339 text format.
   *
   * @var string
   */
  public $lastDetachTimestamp;
  /**
   * Integer license codes indicating which licenses are attached to this disk.
   *
   * @var string[]
   */
  public $licenseCodes;
  /**
   * A list of publicly visible licenses. Reserved for Google's use.
   *
   * @var string[]
   */
  public $licenses;
  /**
   * An opaque location hint used to place the disk close to other resources.
   * This field is for use by internal tools that use the public API.
   *
   * @var string
   */
  public $locationHint;
  /**
   * Name of the resource. Provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @var string
   */
  public $name;
  /**
   * Internal use only.
   *
   * @var string
   */
  public $options;
  protected $paramsType = DiskParams::class;
  protected $paramsDataType = '';
  /**
   * Physical block size of the persistent disk, in bytes. If not present in a
   * request, a default value is used. The currently supported size is 4096,
   * other sizes may be added in the future. If an unsupported value is
   * requested, the error message will list the supported values for the
   * caller's project.
   *
   * @var string
   */
  public $physicalBlockSizeBytes;
  /**
   * Indicates how many IOPS to provision for the disk. This sets the number of
   * I/O operations per second that the disk can handle. Values must be between
   * 10,000 and 120,000. For more details, see theExtreme persistent disk
   * documentation.
   *
   * @var string
   */
  public $provisionedIops;
  /**
   * Indicates how much throughput to provision for the disk. This sets the
   * number of throughput mb per second that the disk can handle. Values must be
   * greater than or equal to 1.
   *
   * @var string
   */
  public $provisionedThroughput;
  /**
   * Output only. [Output Only] URL of the region where the disk resides. Only
   * applicable for regional resources. You must specify this field as part of
   * the HTTP request URL. It is not settable as a field in the request body.
   *
   * @var string
   */
  public $region;
  /**
   * URLs of the zones where the disk should be replicated to. Only applicable
   * for regional resources.
   *
   * @var string[]
   */
  public $replicaZones;
  /**
   * Resource policies applied to this disk for automatic snapshot creations.
   *
   * @var string[]
   */
  public $resourcePolicies;
  protected $resourceStatusType = DiskResourceStatus::class;
  protected $resourceStatusDataType = '';
  /**
   * Output only. Reserved for future use.
   *
   * @var bool
   */
  public $satisfiesPzi;
  /**
   * Output only. [Output Only] Reserved for future use.
   *
   * @var bool
   */
  public $satisfiesPzs;
  /**
   * Output only. [Output Only] Server-defined fully-qualified URL for this
   * resource.
   *
   * @var string
   */
  public $selfLink;
  /**
   * Size, in GB, of the persistent disk. You can specify this field when
   * creating a persistent disk using thesourceImage, sourceSnapshot,
   * orsourceDisk parameter, or specify it alone to create an empty persistent
   * disk.
   *
   * If you specify this field along with a source, the value ofsizeGb must not
   * be less than the size of the source. Acceptable values are greater than 0.
   *
   * @var string
   */
  public $sizeGb;
  /**
   * Output only. [Output Only] URL of the DiskConsistencyGroupPolicy for a
   * secondary disk that was created using a consistency group.
   *
   * @var string
   */
  public $sourceConsistencyGroupPolicy;
  /**
   * Output only. [Output Only] ID of the DiskConsistencyGroupPolicy for a
   * secondary disk that was created using a consistency group.
   *
   * @var string
   */
  public $sourceConsistencyGroupPolicyId;
  /**
   * The source disk used to create this disk. You can provide this as a partial
   * or full URL to the resource. For example, the following are valid values:
   * -         https://www.googleapis.com/compute/v1/projects/project/zones/zone
   * /disks/disk            -         https://www.googleapis.com/compute/v1/proj
   * ects/project/regions/region/disks/disk            -
   * projects/project/zones/zone/disks/disk            -
   * projects/project/regions/region/disks/disk            -
   * zones/zone/disks/disk            -         regions/region/disks/disk
   *
   * @var string
   */
  public $sourceDisk;
  /**
   * Output only. [Output Only] The unique ID of the disk used to create this
   * disk. This value identifies the exact disk that was used to create this
   * persistent disk. For example, if you created the persistent disk from a
   * disk that was later deleted and recreated under the same name, the source
   * disk ID would identify the exact version of the disk that was used.
   *
   * @var string
   */
  public $sourceDiskId;
  /**
   * The source image used to create this disk. If the source image is deleted,
   * this field will not be set.
   *
   * To create a disk with one of the public operating system images, specify
   * the image by its family name. For example, specifyfamily/debian-9 to use
   * the latest Debian 9 image:
   *
   * projects/debian-cloud/global/images/family/debian-9
   *
   * Alternatively, use a specific version of a public operating system image:
   *
   * projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
   *
   * To create a disk with a custom image that you created, specify the image
   * name in the following format:
   *
   * global/images/my-custom-image
   *
   * You can also specify a custom image by its image family, which returns the
   * latest version of the image in that family. Replace the image name with
   * family/family-name:
   *
   * global/images/family/my-image-family
   *
   * @var string
   */
  public $sourceImage;
  protected $sourceImageEncryptionKeyType = CustomerEncryptionKey::class;
  protected $sourceImageEncryptionKeyDataType = '';
  /**
   * Output only. [Output Only] The ID value of the image used to create this
   * disk. This value identifies the exact image that was used to create this
   * persistent disk. For example, if you created the persistent disk from an
   * image that was later deleted and recreated under the same name, the source
   * image ID would identify the exact version of the image that was used.
   *
   * @var string
   */
  public $sourceImageId;
  /**
   * The source instant snapshot used to create this disk. You can provide this
   * as a partial or full URL to the resource. For example, the following are
   * valid values:              - https://www.googleapis.com/compute/v1/projects
   * /project/zones/zone/instantSnapshots/instantSnapshot      -
   * projects/project/zones/zone/instantSnapshots/instantSnapshot     -
   * zones/zone/instantSnapshots/instantSnapshot
   *
   * @var string
   */
  public $sourceInstantSnapshot;
  /**
   * Output only. [Output Only] The unique ID of the instant snapshot used to
   * create this disk. This value identifies the exact instant snapshot that was
   * used to create this persistent disk. For example, if you created the
   * persistent disk from an instant snapshot that was later deleted and
   * recreated under the same name, the source instant snapshot ID would
   * identify the exact version of the instant snapshot that was used.
   *
   * @var string
   */
  public $sourceInstantSnapshotId;
  /**
   * The source snapshot used to create this disk. You can provide this as a
   * partial or full URL to the resource. For example, the following are valid
   * values:              - https://www.googleapis.com/compute/v1/projects/proje
   * ct/global/snapshots/snapshot     -
   * projects/project/global/snapshots/snapshot      - global/snapshots/snapshot
   *
   * @var string
   */
  public $sourceSnapshot;
  protected $sourceSnapshotEncryptionKeyType = CustomerEncryptionKey::class;
  protected $sourceSnapshotEncryptionKeyDataType = '';
  /**
   * Output only. [Output Only] The unique ID of the snapshot used to create
   * this disk. This value identifies the exact snapshot that was used to create
   * this persistent disk. For example, if you created the persistent disk from
   * a snapshot that was later deleted and recreated under the same name, the
   * source snapshot ID would identify the exact version of the snapshot that
   * was used.
   *
   * @var string
   */
  public $sourceSnapshotId;
  /**
   * The full Google Cloud Storage URI where the disk image is stored. This file
   * must be a gzip-compressed tarball whose name ends in .tar.gz or virtual
   * machine disk whose name ends in vmdk. Valid URIs may start with gs:// or
   * https://storage.googleapis.com/. This flag is not optimized for creating
   * multiple disks from a source storage object. To create many disks from a
   * source storage object, use gcloud compute images import instead.
   *
   * @var string
   */
  public $sourceStorageObject;
  /**
   * Output only. [Output Only] The status of disk creation.              -
   * CREATING: Disk is provisioning.      - RESTORING: Source data is being
   * copied into the      disk.      - FAILED: Disk creation failed.      -
   * READY: Disk is ready for use.      - DELETING: Disk is deleting.
   *
   * @var string
   */
  public $status;
  /**
   * The storage pool in which the new disk is created. You can provide this as
   * a partial or full URL to the resource. For example, the following are valid
   * values:              - https://www.googleapis.com/compute/v1/projects/proje
   * ct/zones/zone/storagePools/storagePool      -
   * projects/project/zones/zone/storagePools/storagePool     -
   * zones/zone/storagePools/storagePool
   *
   * @var string
   */
  public $storagePool;
  /**
   * URL of the disk type resource describing which disk type to use to create
   * the disk. Provide this when creating the disk. For
   * example:projects/project/zones/zone/diskTypes/pd-ssd. See Persistent disk
   * types.
   *
   * @var string
   */
  public $type;
  /**
   * Output only. [Output Only] Links to the users of the disk (attached
   * instances) in form:projects/project/zones/zone/instances/instance
   *
   * @var string[]
   */
  public $users;
  /**
   * Output only. [Output Only] URL of the zone where the disk resides. You must
   * specify this field as part of the HTTP request URL. It is not settable as a
   * field in the request body.
   *
   * @var string
   */
  public $zone;

  /**
   * The access mode of the disk.              - READ_WRITE_SINGLE: The default
   * AccessMode, means the      disk can be attached to single instance in RW
   * mode.      - READ_WRITE_MANY: The AccessMode means the disk can be
   * attached to multiple instances in RW mode.      - READ_ONLY_MANY: The
   * AccessMode means the disk can be      attached to multiple instances in RO
   * mode.
   *
   * The AccessMode is only valid for Hyperdisk disk types.
   *
   * Accepted values: READ_ONLY_MANY, READ_WRITE_MANY, READ_WRITE_SINGLE
   *
   * @param self::ACCESS_MODE_* $accessMode
   */
  public function setAccessMode($accessMode)
  {
    $this->accessMode = $accessMode;
  }
  /**
   * @return self::ACCESS_MODE_*
   */
  public function getAccessMode()
  {
    return $this->accessMode;
  }
  /**
   * The architecture of the disk. Valid values are ARM64 or X86_64.
   *
   * Accepted values: ARCHITECTURE_UNSPECIFIED, ARM64, X86_64
   *
   * @param self::ARCHITECTURE_* $architecture
   */
  public function setArchitecture($architecture)
  {
    $this->architecture = $architecture;
  }
  /**
   * @return self::ARCHITECTURE_*
   */
  public function getArchitecture()
  {
    return $this->architecture;
  }
  /**
   * Disk asynchronously replicated into this disk.
   *
   * @param DiskAsyncReplication $asyncPrimaryDisk
   */
  public function setAsyncPrimaryDisk(DiskAsyncReplication $asyncPrimaryDisk)
  {
    $this->asyncPrimaryDisk = $asyncPrimaryDisk;
  }
  /**
   * @return DiskAsyncReplication
   */
  public function getAsyncPrimaryDisk()
  {
    return $this->asyncPrimaryDisk;
  }
  /**
   * Output only. [Output Only] A list of disks this disk is asynchronously
   * replicated to.
   *
   * @param DiskAsyncReplicationList[] $asyncSecondaryDisks
   */
  public function setAsyncSecondaryDisks($asyncSecondaryDisks)
  {
    $this->asyncSecondaryDisks = $asyncSecondaryDisks;
  }
  /**
   * @return DiskAsyncReplicationList[]
   */
  public function getAsyncSecondaryDisks()
  {
    return $this->asyncSecondaryDisks;
  }
  /**
   * Output only. [Output Only] Creation timestamp inRFC3339 text format.
   *
   * @param string $creationTimestamp
   */
  public function setCreationTimestamp($creationTimestamp)
  {
    $this->creationTimestamp = $creationTimestamp;
  }
  /**
   * @return string
   */
  public function getCreationTimestamp()
  {
    return $this->creationTimestamp;
  }
  /**
   * An optional description of this resource. Provide this property when you
   * create the resource.
   *
   * @param string $description
   */
  public function setDescription($description)
  {
    $this->description = $description;
  }
  /**
   * @return string
   */
  public function getDescription()
  {
    return $this->description;
  }
  /**
   * Encrypts the disk using a customer-supplied encryption key or a  customer-
   * managed encryption key.
   *
   * Encryption keys do not protect access to metadata of the disk.
   *
   * After you encrypt a disk with a customer-supplied key, you must provide the
   * same key if you use the disk later. For example, to create a disk snapshot,
   * to create a disk image, to create a machine image, or to attach the disk to
   * a virtual machine.
   *
   * After you encrypt a disk with a customer-managed key,
   * thediskEncryptionKey.kmsKeyName is set to a key *version* name once the
   * disk is created. The disk is encrypted with this version of the key. In the
   * response, diskEncryptionKey.kmsKeyName appears in the following format:
   *
   * "diskEncryptionKey.kmsKeyName":
   * "projects/kms_project_id/locations/region/keyRings/
   * key_region/cryptoKeys/key /cryptoKeysVersions/version
   *
   * If you do not provide an encryption key when creating the disk, then the
   * disk is encrypted using an automatically generated key and you don't need
   * to provide a key to use the disk later.
   *
   * @param CustomerEncryptionKey $diskEncryptionKey
   */
  public function setDiskEncryptionKey(CustomerEncryptionKey $diskEncryptionKey)
  {
    $this->diskEncryptionKey = $diskEncryptionKey;
  }
  /**
   * @return CustomerEncryptionKey
   */
  public function getDiskEncryptionKey()
  {
    return $this->diskEncryptionKey;
  }
  /**
   * Whether this disk is using confidential compute mode.
   *
   * @param bool $enableConfidentialCompute
   */
  public function setEnableConfidentialCompute($enableConfidentialCompute)
  {
    $this->enableConfidentialCompute = $enableConfidentialCompute;
  }
  /**
   * @return bool
   */
  public function getEnableConfidentialCompute()
  {
    return $this->enableConfidentialCompute;
  }
  /**
   * A list of features to enable on the guest operating system. Applicable only
   * for bootable images. Read Enabling guest operating system features to see a
   * list of available options.
   *
   * @param GuestOsFeature[] $guestOsFeatures
   */
  public function setGuestOsFeatures($guestOsFeatures)
  {
    $this->guestOsFeatures = $guestOsFeatures;
  }
  /**
   * @return GuestOsFeature[]
   */
  public function getGuestOsFeatures()
  {
    return $this->guestOsFeatures;
  }
  /**
   * Output only. [Output Only] The unique identifier for the resource. This
   * identifier is defined by the server.
   *
   * @param string $id
   */
  public function setId($id)
  {
    $this->id = $id;
  }
  /**
   * @return string
   */
  public function getId()
  {
    return $this->id;
  }
  /**
   * Output only. [Output Only] Type of the resource. Always compute#disk for
   * disks.
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * A fingerprint for the labels being applied to this disk, which is
   * essentially a hash of the labels set used for optimistic locking. The
   * fingerprint is initially generated by Compute Engine and changes after
   * every request to modify or update labels. You must always provide an up-to-
   * date fingerprint hash in order to update or change labels, otherwise the
   * request will fail with error412 conditionNotMet.
   *
   * To see the latest fingerprint, make a get() request to retrieve a disk.
   *
   * @param string $labelFingerprint
   */
  public function setLabelFingerprint($labelFingerprint)
  {
    $this->labelFingerprint = $labelFingerprint;
  }
  /**
   * @return string
   */
  public function getLabelFingerprint()
  {
    return $this->labelFingerprint;
  }
  /**
   * Labels to apply to this disk. These can be later modified by the setLabels
   * method.
   *
   * @param string[] $labels
   */
  public function setLabels($labels)
  {
    $this->labels = $labels;
  }
  /**
   * @return string[]
   */
  public function getLabels()
  {
    return $this->labels;
  }
  /**
   * Output only. [Output Only] Last attach timestamp inRFC3339 text format.
   *
   * @param string $lastAttachTimestamp
   */
  public function setLastAttachTimestamp($lastAttachTimestamp)
  {
    $this->lastAttachTimestamp = $lastAttachTimestamp;
  }
  /**
   * @return string
   */
  public function getLastAttachTimestamp()
  {
    return $this->lastAttachTimestamp;
  }
  /**
   * Output only. [Output Only] Last detach timestamp inRFC3339 text format.
   *
   * @param string $lastDetachTimestamp
   */
  public function setLastDetachTimestamp($lastDetachTimestamp)
  {
    $this->lastDetachTimestamp = $lastDetachTimestamp;
  }
  /**
   * @return string
   */
  public function getLastDetachTimestamp()
  {
    return $this->lastDetachTimestamp;
  }
  /**
   * Integer license codes indicating which licenses are attached to this disk.
   *
   * @param string[] $licenseCodes
   */
  public function setLicenseCodes($licenseCodes)
  {
    $this->licenseCodes = $licenseCodes;
  }
  /**
   * @return string[]
   */
  public function getLicenseCodes()
  {
    return $this->licenseCodes;
  }
  /**
   * A list of publicly visible licenses. Reserved for Google's use.
   *
   * @param string[] $licenses
   */
  public function setLicenses($licenses)
  {
    $this->licenses = $licenses;
  }
  /**
   * @return string[]
   */
  public function getLicenses()
  {
    return $this->licenses;
  }
  /**
   * An opaque location hint used to place the disk close to other resources.
   * This field is for use by internal tools that use the public API.
   *
   * @param string $locationHint
   */
  public function setLocationHint($locationHint)
  {
    $this->locationHint = $locationHint;
  }
  /**
   * @return string
   */
  public function getLocationHint()
  {
    return $this->locationHint;
  }
  /**
   * Name of the resource. Provided by the client when the resource is created.
   * The name must be 1-63 characters long, and comply withRFC1035.
   * Specifically, the name must be 1-63 characters long and match the regular
   * expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character
   * must be a lowercase letter, and all following characters must be a dash,
   * lowercase letter, or digit, except the last character, which cannot be a
   * dash.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Internal use only.
   *
   * @param string $options
   */
  public function setOptions($options)
  {
    $this->options = $options;
  }
  /**
   * @return string
   */
  public function getOptions()
  {
    return $this->options;
  }
  /**
   * Input only. [Input Only] Additional params passed with the request, but not
   * persisted as part of resource payload.
   *
   * @param DiskParams $params
   */
  public function setParams(DiskParams $params)
  {
    $this->params = $params;
  }
  /**
   * @return DiskParams
   */
  public function getParams()
  {
    return $this->params;
  }
  /**
   * Physical block size of the persistent disk, in bytes. If not present in a
   * request, a default value is used. The currently supported size is 4096,
   * other sizes may be added in the future. If an unsupported value is
   * requested, the error message will list the supported values for the
   * caller's project.
   *
   * @param string $physicalBlockSizeBytes
   */
  public function setPhysicalBlockSizeBytes($physicalBlockSizeBytes)
  {
    $this->physicalBlockSizeBytes = $physicalBlockSizeBytes;
  }
  /**
   * @return string
   */
  public function getPhysicalBlockSizeBytes()
  {
    return $this->physicalBlockSizeBytes;
  }
  /**
   * Indicates how many IOPS to provision for the disk. This sets the number of
   * I/O operations per second that the disk can handle. Values must be between
   * 10,000 and 120,000. For more details, see theExtreme persistent disk
   * documentation.
   *
   * @param string $provisionedIops
   */
  public function setProvisionedIops($provisionedIops)
  {
    $this->provisionedIops = $provisionedIops;
  }
  /**
   * @return string
   */
  public function getProvisionedIops()
  {
    return $this->provisionedIops;
  }
  /**
   * Indicates how much throughput to provision for the disk. This sets the
   * number of throughput mb per second that the disk can handle. Values must be
   * greater than or equal to 1.
   *
   * @param string $provisionedThroughput
   */
  public function setProvisionedThroughput($provisionedThroughput)
  {
    $this->provisionedThroughput = $provisionedThroughput;
  }
  /**
   * @return string
   */
  public function getProvisionedThroughput()
  {
    return $this->provisionedThroughput;
  }
  /**
   * Output only. [Output Only] URL of the region where the disk resides. Only
   * applicable for regional resources. You must specify this field as part of
   * the HTTP request URL. It is not settable as a field in the request body.
   *
   * @param string $region
   */
  public function setRegion($region)
  {
    $this->region = $region;
  }
  /**
   * @return string
   */
  public function getRegion()
  {
    return $this->region;
  }
  /**
   * URLs of the zones where the disk should be replicated to. Only applicable
   * for regional resources.
   *
   * @param string[] $replicaZones
   */
  public function setReplicaZones($replicaZones)
  {
    $this->replicaZones = $replicaZones;
  }
  /**
   * @return string[]
   */
  public function getReplicaZones()
  {
    return $this->replicaZones;
  }
  /**
   * Resource policies applied to this disk for automatic snapshot creations.
   *
   * @param string[] $resourcePolicies
   */
  public function setResourcePolicies($resourcePolicies)
  {
    $this->resourcePolicies = $resourcePolicies;
  }
  /**
   * @return string[]
   */
  public function getResourcePolicies()
  {
    return $this->resourcePolicies;
  }
  /**
   * Output only. [Output Only] Status information for the disk resource.
   *
   * @param DiskResourceStatus $resourceStatus
   */
  public function setResourceStatus(DiskResourceStatus $resourceStatus)
  {
    $this->resourceStatus = $resourceStatus;
  }
  /**
   * @return DiskResourceStatus
   */
  public function getResourceStatus()
  {
    return $this->resourceStatus;
  }
  /**
   * Output only. Reserved for future use.
   *
   * @param bool $satisfiesPzi
   */
  public function setSatisfiesPzi($satisfiesPzi)
  {
    $this->satisfiesPzi = $satisfiesPzi;
  }
  /**
   * @return bool
   */
  public function getSatisfiesPzi()
  {
    return $this->satisfiesPzi;
  }
  /**
   * Output only. [Output Only] Reserved for future use.
   *
   * @param bool $satisfiesPzs
   */
  public function setSatisfiesPzs($satisfiesPzs)
  {
    $this->satisfiesPzs = $satisfiesPzs;
  }
  /**
   * @return bool
   */
  public function getSatisfiesPzs()
  {
    return $this->satisfiesPzs;
  }
  /**
   * Output only. [Output Only] Server-defined fully-qualified URL for this
   * resource.
   *
   * @param string $selfLink
   */
  public function setSelfLink($selfLink)
  {
    $this->selfLink = $selfLink;
  }
  /**
   * @return string
   */
  public function getSelfLink()
  {
    return $this->selfLink;
  }
  /**
   * Size, in GB, of the persistent disk. You can specify this field when
   * creating a persistent disk using thesourceImage, sourceSnapshot,
   * orsourceDisk parameter, or specify it alone to create an empty persistent
   * disk.
   *
   * If you specify this field along with a source, the value ofsizeGb must not
   * be less than the size of the source. Acceptable values are greater than 0.
   *
   * @param string $sizeGb
   */
  public function setSizeGb($sizeGb)
  {
    $this->sizeGb = $sizeGb;
  }
  /**
   * @return string
   */
  public function getSizeGb()
  {
    return $this->sizeGb;
  }
  /**
   * Output only. [Output Only] URL of the DiskConsistencyGroupPolicy for a
   * secondary disk that was created using a consistency group.
   *
   * @param string $sourceConsistencyGroupPolicy
   */
  public function setSourceConsistencyGroupPolicy($sourceConsistencyGroupPolicy)
  {
    $this->sourceConsistencyGroupPolicy = $sourceConsistencyGroupPolicy;
  }
  /**
   * @return string
   */
  public function getSourceConsistencyGroupPolicy()
  {
    return $this->sourceConsistencyGroupPolicy;
  }
  /**
   * Output only. [Output Only] ID of the DiskConsistencyGroupPolicy for a
   * secondary disk that was created using a consistency group.
   *
   * @param string $sourceConsistencyGroupPolicyId
   */
  public function setSourceConsistencyGroupPolicyId($sourceConsistencyGroupPolicyId)
  {
    $this->sourceConsistencyGroupPolicyId = $sourceConsistencyGroupPolicyId;
  }
  /**
   * @return string
   */
  public function getSourceConsistencyGroupPolicyId()
  {
    return $this->sourceConsistencyGroupPolicyId;
  }
  /**
   * The source disk used to create this disk. You can provide this as a partial
   * or full URL to the resource. For example, the following are valid values:
   * -         https://www.googleapis.com/compute/v1/projects/project/zones/zone
   * /disks/disk            -         https://www.googleapis.com/compute/v1/proj
   * ects/project/regions/region/disks/disk            -
   * projects/project/zones/zone/disks/disk            -
   * projects/project/regions/region/disks/disk            -
   * zones/zone/disks/disk            -         regions/region/disks/disk
   *
   * @param string $sourceDisk
   */
  public function setSourceDisk($sourceDisk)
  {
    $this->sourceDisk = $sourceDisk;
  }
  /**
   * @return string
   */
  public function getSourceDisk()
  {
    return $this->sourceDisk;
  }
  /**
   * Output only. [Output Only] The unique ID of the disk used to create this
   * disk. This value identifies the exact disk that was used to create this
   * persistent disk. For example, if you created the persistent disk from a
   * disk that was later deleted and recreated under the same name, the source
   * disk ID would identify the exact version of the disk that was used.
   *
   * @param string $sourceDiskId
   */
  public function setSourceDiskId($sourceDiskId)
  {
    $this->sourceDiskId = $sourceDiskId;
  }
  /**
   * @return string
   */
  public function getSourceDiskId()
  {
    return $this->sourceDiskId;
  }
  /**
   * The source image used to create this disk. If the source image is deleted,
   * this field will not be set.
   *
   * To create a disk with one of the public operating system images, specify
   * the image by its family name. For example, specifyfamily/debian-9 to use
   * the latest Debian 9 image:
   *
   * projects/debian-cloud/global/images/family/debian-9
   *
   * Alternatively, use a specific version of a public operating system image:
   *
   * projects/debian-cloud/global/images/debian-9-stretch-vYYYYMMDD
   *
   * To create a disk with a custom image that you created, specify the image
   * name in the following format:
   *
   * global/images/my-custom-image
   *
   * You can also specify a custom image by its image family, which returns the
   * latest version of the image in that family. Replace the image name with
   * family/family-name:
   *
   * global/images/family/my-image-family
   *
   * @param string $sourceImage
   */
  public function setSourceImage($sourceImage)
  {
    $this->sourceImage = $sourceImage;
  }
  /**
   * @return string
   */
  public function getSourceImage()
  {
    return $this->sourceImage;
  }
  /**
   * Thecustomer-supplied encryption key of the source image. Required if the
   * source image is protected by a customer-supplied encryption key.
   *
   * @param CustomerEncryptionKey $sourceImageEncryptionKey
   */
  public function setSourceImageEncryptionKey(CustomerEncryptionKey $sourceImageEncryptionKey)
  {
    $this->sourceImageEncryptionKey = $sourceImageEncryptionKey;
  }
  /**
   * @return CustomerEncryptionKey
   */
  public function getSourceImageEncryptionKey()
  {
    return $this->sourceImageEncryptionKey;
  }
  /**
   * Output only. [Output Only] The ID value of the image used to create this
   * disk. This value identifies the exact image that was used to create this
   * persistent disk. For example, if you created the persistent disk from an
   * image that was later deleted and recreated under the same name, the source
   * image ID would identify the exact version of the image that was used.
   *
   * @param string $sourceImageId
   */
  public function setSourceImageId($sourceImageId)
  {
    $this->sourceImageId = $sourceImageId;
  }
  /**
   * @return string
   */
  public function getSourceImageId()
  {
    return $this->sourceImageId;
  }
  /**
   * The source instant snapshot used to create this disk. You can provide this
   * as a partial or full URL to the resource. For example, the following are
   * valid values:              - https://www.googleapis.com/compute/v1/projects
   * /project/zones/zone/instantSnapshots/instantSnapshot      -
   * projects/project/zones/zone/instantSnapshots/instantSnapshot     -
   * zones/zone/instantSnapshots/instantSnapshot
   *
   * @param string $sourceInstantSnapshot
   */
  public function setSourceInstantSnapshot($sourceInstantSnapshot)
  {
    $this->sourceInstantSnapshot = $sourceInstantSnapshot;
  }
  /**
   * @return string
   */
  public function getSourceInstantSnapshot()
  {
    return $this->sourceInstantSnapshot;
  }
  /**
   * Output only. [Output Only] The unique ID of the instant snapshot used to
   * create this disk. This value identifies the exact instant snapshot that was
   * used to create this persistent disk. For example, if you created the
   * persistent disk from an instant snapshot that was later deleted and
   * recreated under the same name, the source instant snapshot ID would
   * identify the exact version of the instant snapshot that was used.
   *
   * @param string $sourceInstantSnapshotId
   */
  public function setSourceInstantSnapshotId($sourceInstantSnapshotId)
  {
    $this->sourceInstantSnapshotId = $sourceInstantSnapshotId;
  }
  /**
   * @return string
   */
  public function getSourceInstantSnapshotId()
  {
    return $this->sourceInstantSnapshotId;
  }
  /**
   * The source snapshot used to create this disk. You can provide this as a
   * partial or full URL to the resource. For example, the following are valid
   * values:              - https://www.googleapis.com/compute/v1/projects/proje
   * ct/global/snapshots/snapshot     -
   * projects/project/global/snapshots/snapshot      - global/snapshots/snapshot
   *
   * @param string $sourceSnapshot
   */
  public function setSourceSnapshot($sourceSnapshot)
  {
    $this->sourceSnapshot = $sourceSnapshot;
  }
  /**
   * @return string
   */
  public function getSourceSnapshot()
  {
    return $this->sourceSnapshot;
  }
  /**
   * Thecustomer-supplied encryption key of the source snapshot. Required if the
   * source snapshot is protected by a customer-supplied encryption key.
   *
   * @param CustomerEncryptionKey $sourceSnapshotEncryptionKey
   */
  public function setSourceSnapshotEncryptionKey(CustomerEncryptionKey $sourceSnapshotEncryptionKey)
  {
    $this->sourceSnapshotEncryptionKey = $sourceSnapshotEncryptionKey;
  }
  /**
   * @return CustomerEncryptionKey
   */
  public function getSourceSnapshotEncryptionKey()
  {
    return $this->sourceSnapshotEncryptionKey;
  }
  /**
   * Output only. [Output Only] The unique ID of the snapshot used to create
   * this disk. This value identifies the exact snapshot that was used to create
   * this persistent disk. For example, if you created the persistent disk from
   * a snapshot that was later deleted and recreated under the same name, the
   * source snapshot ID would identify the exact version of the snapshot that
   * was used.
   *
   * @param string $sourceSnapshotId
   */
  public function setSourceSnapshotId($sourceSnapshotId)
  {
    $this->sourceSnapshotId = $sourceSnapshotId;
  }
  /**
   * @return string
   */
  public function getSourceSnapshotId()
  {
    return $this->sourceSnapshotId;
  }
  /**
   * The full Google Cloud Storage URI where the disk image is stored. This file
   * must be a gzip-compressed tarball whose name ends in .tar.gz or virtual
   * machine disk whose name ends in vmdk. Valid URIs may start with gs:// or
   * https://storage.googleapis.com/. This flag is not optimized for creating
   * multiple disks from a source storage object. To create many disks from a
   * source storage object, use gcloud compute images import instead.
   *
   * @param string $sourceStorageObject
   */
  public function setSourceStorageObject($sourceStorageObject)
  {
    $this->sourceStorageObject = $sourceStorageObject;
  }
  /**
   * @return string
   */
  public function getSourceStorageObject()
  {
    return $this->sourceStorageObject;
  }
  /**
   * Output only. [Output Only] The status of disk creation.              -
   * CREATING: Disk is provisioning.      - RESTORING: Source data is being
   * copied into the      disk.      - FAILED: Disk creation failed.      -
   * READY: Disk is ready for use.      - DELETING: Disk is deleting.
   *
   * Accepted values: CREATING, DELETING, FAILED, READY, RESTORING, UNAVAILABLE
   *
   * @param self::STATUS_* $status
   */
  public function setStatus($status)
  {
    $this->status = $status;
  }
  /**
   * @return self::STATUS_*
   */
  public function getStatus()
  {
    return $this->status;
  }
  /**
   * The storage pool in which the new disk is created. You can provide this as
   * a partial or full URL to the resource. For example, the following are valid
   * values:              - https://www.googleapis.com/compute/v1/projects/proje
   * ct/zones/zone/storagePools/storagePool      -
   * projects/project/zones/zone/storagePools/storagePool     -
   * zones/zone/storagePools/storagePool
   *
   * @param string $storagePool
   */
  public function setStoragePool($storagePool)
  {
    $this->storagePool = $storagePool;
  }
  /**
   * @return string
   */
  public function getStoragePool()
  {
    return $this->storagePool;
  }
  /**
   * URL of the disk type resource describing which disk type to use to create
   * the disk. Provide this when creating the disk. For
   * example:projects/project/zones/zone/diskTypes/pd-ssd. See Persistent disk
   * types.
   *
   * @param string $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
  /**
   * Output only. [Output Only] Links to the users of the disk (attached
   * instances) in form:projects/project/zones/zone/instances/instance
   *
   * @param string[] $users
   */
  public function setUsers($users)
  {
    $this->users = $users;
  }
  /**
   * @return string[]
   */
  public function getUsers()
  {
    return $this->users;
  }
  /**
   * Output only. [Output Only] URL of the zone where the disk resides. You must
   * specify this field as part of the HTTP request URL. It is not settable as a
   * field in the request body.
   *
   * @param string $zone
   */
  public function setZone($zone)
  {
    $this->zone = $zone;
  }
  /**
   * @return string
   */
  public function getZone()
  {
    return $this->zone;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Disk::class, 'Google_Service_Compute_Disk');
