<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudHealthcare;

class DicomFilterConfig extends \Google\Model
{
  /**
   * The Cloud Storage location of the filter configuration file. The `gcs_uri`
   * must be in the format `gs://bucket/path/to/object`. The filter
   * configuration file must contain a list of resource paths separated by
   * newline characters (\n or \r\n). Each resource path must be in the format
   * "/studies/{studyUID}[/series/{seriesUID}[/instances/{instanceUID}]]" The
   * Cloud Healthcare API service account must have the
   * `roles/storage.objectViewer` Cloud IAM role for this Cloud Storage
   * location.
   *
   * @var string
   */
  public $resourcePathsGcsUri;

  /**
   * The Cloud Storage location of the filter configuration file. The `gcs_uri`
   * must be in the format `gs://bucket/path/to/object`. The filter
   * configuration file must contain a list of resource paths separated by
   * newline characters (\n or \r\n). Each resource path must be in the format
   * "/studies/{studyUID}[/series/{seriesUID}[/instances/{instanceUID}]]" The
   * Cloud Healthcare API service account must have the
   * `roles/storage.objectViewer` Cloud IAM role for this Cloud Storage
   * location.
   *
   * @param string $resourcePathsGcsUri
   */
  public function setResourcePathsGcsUri($resourcePathsGcsUri)
  {
    $this->resourcePathsGcsUri = $resourcePathsGcsUri;
  }
  /**
   * @return string
   */
  public function getResourcePathsGcsUri()
  {
    return $this->resourcePathsGcsUri;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(DicomFilterConfig::class, 'Google_Service_CloudHealthcare_DicomFilterConfig');
