<h4 class="title mt-4 mb-3"><?php echo e(get_phrase('Contact Information')); ?></h4>
<?php
    $contact_info = get_frontend_settings('contact_info');
    if ($contact_info) {
        $contact_info = json_decode($contact_info, true);
    } else {
        $contact_info = ['email' => '', 'phone' => '', 'address' => '', 'office_hours' => ''];
    }
?>

<form action="<?php echo e(route('admin.website.settings.update')); ?>" method="post" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="type" value="contact_info">
    <div class="row">
        <div class="col-md-7">
            <div class="fpb-7 mb-3">
                <label class="form-label ol-form-label"><?php echo e(get_phrase('Contact Email')); ?></label>
                <textarea name="email" rows="2" class="form-control ol-form-control"><?php echo e($contact_info['email']); ?></textarea>
            </div>
            <div class="fpb-7 mb-3">
                <label class="form-label ol-form-label"><?php echo e(get_phrase('Phone Number')); ?></label>
                <textarea name="phone" rows="2" class="form-control ol-form-control"><?php echo e($contact_info['phone']); ?></textarea>
            </div>
            <div class="fpb-7 mb-3">
                <label class="form-label ol-form-label"><?php echo e(get_phrase('Address')); ?></label>
                <textarea name="address" rows="2" class="form-control ol-form-control"><?php echo e($contact_info['address']); ?></textarea>
            </div>
            <div class="fpb-7 mb-3">
                <label class="form-label ol-form-label"><?php echo e(get_phrase('Office Hours')); ?></label>
                <textarea name="office_hours" rows="2" class="form-control ol-form-control"><?php echo e($contact_info['office_hours']); ?></textarea>
            </div>
            <div class="fpb-7 mb-3">
                <label class="form-label ol-form-label"><?php echo e(get_phrase('Location')); ?> <small class="text-12px text-muted">(<?php echo e(get_phrase('Latitude')); ?>, <?php echo e(get_phrase('Longitude')); ?>)</small></label>
                <input name="location" class="form-control ol-form-control" placeholder="40.689880, -74.045203" value="<?php echo e($contact_info['location'] ?? ''); ?>">
            </div>
            <div class="fpb-7 mb-3">
                <button type="submit" class="btn ol-btn-primary"><?php echo e(get_phrase('Submit')); ?></button>
            </div>
        </div>
    </div>
</form>
<?php /**PATH /home1/cwmsozbb/public_html/resources/views/admin/setting/contact_information.blade.php ENDPATH**/ ?>