<!DOCTYPE html>
<html lang="en">

<head>
    <title><?php echo e(get_phrase('Course Playing Page')); ?>| <?php echo e(config('app.name')); ?></title>
    <!-- all the meta tags -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta content="" name="description" />
    <meta content="" name="author" />
    <!-- all the css files -->
    <link rel="shortcut icon" href="<?php echo e(asset(get_frontend_settings('favicon'))); ?>" />
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/default/css/bootstrap.min.css')); ?>">
    <!-- Fontawesome CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/course_player/vendors/fontawesome/fontawesome.css')); ?>" />
    <!-- Player CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/plyr/plyr.css')); ?>" />
    <!-- Main CSS -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/course_player/css/style.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/course_player/css/custom.css')); ?>" />
    <!-- FlatIcons Css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/icons/uicons-bold-rounded/css/uicons-bold-rounded.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/icons/uicons-bold-straight/css/uicons-bold-straight.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/icons/uicons-regular-rounded/css/uicons-regular-rounded.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/icons/uicons-solid-rounded/css/uicons-solid-rounded.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/icons/uicons-solid-rounded/css/uicons-solid-rounded.css')); ?>" />

    <!-- Summernote Css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/global/summernote/summernote.min.css')); ?>">

    <!-- Yaireo Tagify -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/global/tagify-master/dist/tagify.css')); ?>" rel="stylesheet" type="text/css" />

</head>

<body oncontextmenu="return false;">

    <!-- Start Course Playing Header -->
    <header class="playing-header-section">
        <?php echo $__env->make('course_player.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </header>
    <!-- End Course Playing Header -->

    <!-- Start Course Playing Video and Playlist Area -->
    <section class="video-playlist-section">
        <div class="my-container">
            <div class="row">
                <div class="col-lg-8" id="player_content">
                    <?php echo $__env->make('course_player.player_page', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <!-- Tab -->
                    <div class="course-video-navtab">
                        <?php echo $__env->make('course_player.tab_bar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>
                </div>
                <div class="col-lg-4" id="player_side_bar">
                    <?php echo $__env->make('course_player.side_bar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
            </div>
        </div>
    </section>
    <!-- End Course Playing Video and Playlist Area -->

    <!-- Main Jquery -->
    <script src="<?php echo e(asset('assets/frontend/default/js/jquery-3.7.1.min.js')); ?>"></script>

    <!-- Bootstrap bundle with popper -->
    <script src="<?php echo e(asset('assets/frontend/default/js/bootstrap.bundle.min.js')); ?>"></script>

    <!-- Summernote Css -->
    <script src="<?php echo e(asset('assets/global/summernote/summernote.min.js')); ?>"></script>

    <!-- Fontawesome JS -->
    <script src="<?php echo e(asset('assets/global/course_player/vendors/fontawesome/fontawesome.all.min.js')); ?>"></script>

    <!-- Player JS -->
    <script src="<?php echo e(asset('assets/global/plyr/plyr.js')); ?>"></script>

    <!-- Yaireo Tagify -->
    <script src="<?php echo e(asset('assets/global/tagify-master/dist/tagify.min.js')); ?>"></script>

    <!-- Jquery form -->
    <script type="text/javascript" src="<?php echo e(asset('assets/global/jquery-form/jquery.form.min.js')); ?>"></script>

    <!-- toster file -->
    <?php echo $__env->make('frontend.default.toaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Custom Script -->
    <script src="<?php echo e(asset('assets/global/course_player/js/script.js')); ?>"></script>
	<script>
	
		$(document).ready(function(){
			$('.remove_video_src').attr("src","");
		});
		
		document.addEventListener('contextmenu', event => event.preventDefault());
		document.addEventListener('keydown', function(event) {
			if (event.ctrlKey && (event.key === 's' || event.key === 'u')) {
				event.preventDefault();
			}
		});
	</script>

    <?php echo $__env->make('course_player.init', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->yieldPushContent('js'); ?>
</body>

</html>
<?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/course_player/index.blade.php ENDPATH**/ ?>