<?php
    $participants = DB::table('quiz_submissions')
        ->join('users', 'quiz_submissions.user_id', 'users.id')
        ->where('quiz_submissions.quiz_id', $id)
        ->select('users.name', 'users.id')
        ->distinct('quiz_submissions.user_id')
        ->get();
?>

<style>
    .participants {
        min-height: 500px;
    }

    input[type="radio"]:checked {
        border-color: initial;
    }

    .gradient-border {
        background: #fff;
        border: 2px solid #2f57ef;
        color: #212529;
        transition: .3s;
    }

    .gradient-border:hover {
        color: #fff;
        background: #2f57ef;
    }

    .serial {
        width: 30px;
        height: 30px;
        background: #F2F3F5;
        border-radius: 30px;
        display: flex;
        align-items: center;
        justify-content: center;
    }
</style>


<div class="row">
    <div class="col-sm-3 border-end">
        <div class="participants">
            <?php $__currentLoopData = $participants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $participant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <input type="radio" class="btn-check" name="participants" id="<?php echo e($participant->id); ?>" autocomplete="off">
                <label class="btn btn-outline-dark border-0 w-100 text-capitalize fs-14px py-2"
                    for="<?php echo e($participant->id); ?>" onclick="loadResult(this)"><?php echo e($participant->name); ?></label>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    <div class="col-sm-9">
        <div class="result-preview"></div>
    </div>
</div>

<script>
    $(document).ready(function() {
        $('select[name="participant"]').change(function(e) {
            e.preventDefault();

            let userId = $(this).val();
            let quizId = "<?php echo e($id); ?>";

            if (userId && quizId) {
                $.ajax({
                    type: "get",
                    url: "<?php echo e(route('admin.quiz.participant.result')); ?>",
                    data: {
                        quizId: quizId,
                        participant: userId
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        $('select[name="submission"]').html(response);
                    }
                });
            }
        });

        $('select[name="submission"]').change(function(e) {
            e.preventDefault();

            let submitId = $(this).val();
            if (submitId) {
                $.ajax({
                    type: "get",
                    url: "<?php echo e(route('admin.quiz.result.preview')); ?>",
                    data: {
                        submitId: submitId,
                    },
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(response) {
                        $('.result-preview').html(response);
                    }
                });
            }
        });
    });
</script>

<script>
    function loadResult(elem) {
        let participantId = $(elem).attr('for');
        let quizId = "<?php echo e($id); ?>";

        if (quizId && participantId) {
            $.ajax({
                type: "get",
                url: "<?php echo e(route('admin.quiz.result.preview')); ?>",
                data: {
                    quizId: quizId,
                    participantId: participantId,
                },
                success: function(response) {
                    $('.result-preview').html(response);
                }
            });
        }
    }
</script>
<?php echo $__env->make('admin.init', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/admin/quiz_result/index.blade.php ENDPATH**/ ?>