<div class="fpb7 mb-3">
    <label class="form-label ol-form-label" for="options">
        <?php echo e(get_phrase('Options')); ?>

        <span class="text-danger ms-1">*</span>
    </label>
    <input class="form-control ol-form-control tagify" type="text" data-role="tagsinput" id="options" name="options"
        value="<?php echo e($question->options); ?>" placeholder="<?php echo e(get_phrase('Your questions here')); ?>">
    <small><?php echo e(get_phrase('You can keep multiple options. Just put an option and hit enter.')); ?></small>
</div>


<div class="row">
    <div class="col-sm-12">
        <div class="mb-3">
            <label class="form-label ol-form-label">
                <?php echo e(get_phrase('Answer')); ?>

                <span class="text-danger ms-1">*</span>
            </label>
            <select class="form-control ol-form-control ol-select2" name="answer[]" data-toggle="select2"
                id="answer-select2" multiple>
                <option value=""><?php echo e(get_phrase('Select an option')); ?></option>
                <?php $__currentLoopData = json_decode($question->options, true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($option); ?>" <?php if(in_array($option, json_decode($question->answer, true))): ?> selected <?php endif; ?>>
                        <?php echo e($option); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <small><?php echo e(get_phrase('You can select multiple answers.')); ?></small>
        </div>
    </div>
</div>

<?php echo $__env->make('admin.init', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<script>
    var inputElm = document.querySelector('#options');
    inputElm.addEventListener('change', onChange)

    function onChange(e) {
        let values = e.target.value
        let varArr = JSON.parse(values)
        let answerSelect2 = document.querySelector('#answer-select2')

        answerSelect2.innerHTML = ''
        varArr.forEach(item => {
            let option = document.createElement('option')
            option.text = item.value
            option.value = item.value
            answerSelect2.add(option)
        });
    }
</script>
<?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/admin/questions/edit_mcq.blade.php ENDPATH**/ ?>