<?php
    $categories = App\Models\BootcampCategory::get();
    $active_category = request()->route()->parameter('category');
    $route_queries = request()->query();
    $route_queries = collect($route_queries)->except('page')->all();
?>

<div class="sidebar">
    <form class="mb-4" action="<?php echo e(route('bootcamps', $active_category)); ?>" method="get">
        <div class="widget">
            <div class="search">
                <input type="text" class="form-control" name="search" placeholder="<?php echo e(get_phrase('Search...')); ?>"
                    value="<?php echo e(request('search')); ?>">
                <button type="submit" class="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
            </div>
        </div>
    </form>


    <!------------------- categories start ------------------->
    <div class="widget overlay-content overlay-content-max-h-400">
        <h4 class="widget-title"><?php echo e(get_phrase('Categories')); ?></h4>
        <ul class="entry-widget overflow-hidden" id="parent-category">
            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $route_queries['category'] = $category->slug; ?>

                <li class="category <?php if($category->slug == $active_category): ?> active <?php endif; ?>" id="<?php echo e($category->slud); ?>">
                    <a href="<?php echo e(route('bootcamps', $route_queries)); ?>"
                        class="d-flex align-items-center justify-content-between">
                        <span><?php echo e($category->title); ?></span>
                        <span><?php echo e(count_bootcamps_by_category($category->id)); ?></span>
                    </a>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <div class="down-text" id="see-more">
            <?php echo e(get_phrase('Show More')); ?>

        </div>
    </div>
    <!------------------- categories end ------------------->
</div>


<?php $__env->startPush('js'); ?>
    <script>
        $(document).ready(function() {
            $('#see-more').click(function(e) {
                e.preventDefault();
                $(this).toggleClass('active');
                let show_more = $(this).html();

                if ($(this).hasClass('active')) {
                    $(this).css('margin-top', '20px');
                    $(this).text('<?php echo e(get_phrase('Show Less')); ?>');
                } else {
                    $(this).css('margin-top', '0px');
                    $(this).html('<?php echo e(get_phrase('Show More')); ?>');
                }
            });

            var scrollTop = $(".scrollTop");
            $(scrollTop).click(function() {
                $('html, body').animate({
                    scrollTop: 0
                }, 100);
                return false;
            });

            $('input[type="radio"]').change(function(e) {
                $('#filter-bootcamps').submit();
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home1/cwmsozbb/public_html/resources/views/frontend/default/bootcamp/filter.blade.php ENDPATH**/ ?>