
<?php $__env->startPush('title', get_phrase('Home')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/default/fonts/clinton/font.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/frontend/default/fonts/poppins/stylesheet.css')); ?>">
    <style>
        body {
            background-color: #FAFEFF;
        }

        .info {
            font-family: 'Poppins' !important;
            font-weight: 400;
            font-size: 16px;
            line-height: 24px;
            color: #7E8088;
        }
        

        h1,
        h1 .highlight {
            font-family: 'clinton-bold' !important;
        }

        .font-italic {
            font-family: 'clinton-bold-italic' !important;
        }

        h2,
        h3,
        h4,
        h5,
        h6,
        .hero-rated-profile-area .info {
            font-family: 'clinton-bold' !important;
        }

        body,
        p,
        span,
        button,
        a {
            font-family: 'Poppins' !important;
            font-weight: normal;
        }

        .btn-danger-1,
        .btn-whitelight {
            font-family: 'Poppins' !important;
            font-weight: normal;
        }

        .subtitle-1,
        .subtitle-2,
        .subtitle-3,
        .subtitle-4,
        .subtitle-5{
            font-family: 'Poppins' !important;
            font-weight: 500;
        }
        .accordion-button{
            font-weight: 500 !important;
        }

        .learning-coding-card, .dev-course-card, .dev-student-testimonial, .dev-news-card{
            border: none;
            border-radius: 12px;
            background: #FFF;
            box-shadow: 0px 14px 32px 0px rgba(147, 148, 158, 0.20);
        }
        .dev-course-card:hover, .dev-news-card:hover{
            box-shadow: 0px 14px 32px 0px rgba(249, 92, 22, 0.17);
        }
        .text-dev-warning{
            color: #030303 !important;
            transition: color 0.3s;
        }
        .dev-news-link:hover .text-dev-warning{
            color: #F95C16 !important;
            transition: color 0.3s;
        }
        .accordion, .accordion-button, .accordion-body, .accordion-header, .accordion-item{
            background-color: #fafeff;
        }
        
		
		.development-banner-area { margin: 75px 0; }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

    <!-- Banner Area Start -->
    <?php
        $bannerData = json_decode(get_frontend_settings('banner_image'));
        $banneractive = get_frontend_settings('home_page');
        if ($bannerData !== null && is_object($bannerData) && property_exists($bannerData, $banneractive)) {
            $banner = asset(json_decode(get_frontend_settings('banner_image'))->$banneractive);
        } else {
            $defaultBanner = asset('assets/frontend/default/image/development-banner1.webp');
        }
        $total_students = DB::table('users')->where('role', 'student')->get();
    ?>
	<section class="dev-banner-section">
    <!-- <section class="dev-banner-section" style="background-image: url(<?php echo e(isset($banner) ? $banner : $defaultBanner); ?>);"> -->
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <div class="development-banner-area">
                        <img src="<?php echo e(isset($banner) ? $banner : $defaultBanner); ?>" />
                    </div>
                </div>
				<div class="col-md-6">
                    <div class="development-banner-area">
                        <?php
                            $banner_title = get_frontend_settings('banner_title');
                            $arr = explode(' ', $banner_title);
                            $phrase_two = end($arr);
                            $phrase_one = str_replace($phrase_two, '', $banner_title);
                        ?>
						<div class="mt-5 pt-5"></div>
                        <h1 class="title mt-5 pt-5"><?php echo e($phrase_one); ?></h1>
                        <h3 class="sub-title"><?php echo e($phrase_two); ?></h3>
						<a href="javascript:void(0);" class="video-play-btn" type="button" data-bs-toggle="modal" data-bs-target="#promoVideo">
                            <span class="icon">
                                <img src="<?php echo e(asset('assets/frontend/default/image/play-black-large.svg')); ?>" alt="">
                            </span>
                            <span><?php echo e(get_phrase('Watch Video')); ?></span>
                        </a>
						<div class="text-center">
							<?php
							    
								if (isset(auth()->user()->id)) {
									$is_enrolled = DB::table('enrollments')
										->where('user_id', auth()->user()->id)
										->where('course_id', $course_details->id)
										->exists();

									$in_cart = DB::table('cart_items')
										->where('user_id', auth()->user()->id)
										->where('course_id', $course_details->id)
										->exists();

									$in_wishlist = DB::table('wishlists')
										->where('user_id', auth()->user()->id)
										->where('course_id', $course_details->id)
										->exists();

									$pending_course_for_payment = DB::table('offline_payments')
										->where('user_id', auth()->user()->id)
										->where('status', 0)
										->first();

									$pending_course = $pending_course_for_payment ? json_decode($pending_course_for_payment->items, true) : [];
								}
							?>
						
							<?php if(isset(auth()->user()->id)): ?>
									<?php if($is_enrolled): ?>
										<a href="<?php echo e(route('my.courses')); ?>" class="eBtn gradient mb-3">
											<?php echo e(get_phrase('Start Now')); ?>

										</a>
									<?php else: ?>
										<a href="<?php echo e(route('purchase.course', $course_details->id)); ?>" class="eBtn gradient">
											<?php echo e(get_phrase($course_details->is_paid ? get_phrase('Enroll Now') : get_phrase('Enroll Now'))); ?>

										</a>
									<?php endif; ?>								
							<?php else: ?>
								<a href="<?php echo e(route('purchase.course', $course_details->id)); ?>" class="eBtn gradient mt-3">
									<?php echo e(get_phrase($course_details->is_paid ? get_phrase('Enroll Now') : get_phrase('Enroll Now'))); ?>

								</a>
							<?php endif; ?>
						</div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Banner Area End -->

    <!-- Hero Area Start -->
    <section class="development-hero-section1 mb-80">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="development-hero-area1 d-flex align-items-center justify-content-between">
                        <div class="hero-rated-profile-area">
                            <ul class="profiles d-flex align-items-center">

                                <?php
                                    $students = DB::table('users')->where('role', 'student')->take(2)->latest('id')->get();
                                ?>
                                <?php $__currentLoopData = $students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <img data-bs-toggle="tooltip" title="<?php echo e($student->name); ?>" src="<?php echo e(get_image($student->photo)); ?>" alt="">
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <li>
                                    <img src="<?php echo e(asset('assets/frontend/default/image/arrow-rotate-white-16.svg')); ?>" alt="">
                                </li>
                            </ul>
                            <p class="info"><?php echo e(count($total_students)); ?>+ <?php echo e(get_phrase('Students')); ?></p>
                        </div>
                        <p class="hero-info text-center">
						<?php echo e(get_frontend_settings('banner_sub_title')); ?>

						<!--
						<p class="title" style="font-size: 20px; color: #FFFFFF;"><?php echo e($phrase_one); ?><span class=" font-italic highlight"><?php echo e($phrase_two); ?></span></p>
						<a href="javascript:void(0);" class="mt-3 video-play-btn" type="button" data-bs-toggle="modal" data-bs-target="#promoVideo">
                            <span class="icon">
                                <img src="<?php echo e(asset('assets/frontend/default/image/play-black-large.svg')); ?>" alt="">
                            </span>
                            <span><?php echo e(get_phrase('Watch Intro')); ?></span>
                        </a>
						</p>
						-->
						<div class="">
							<?php
								if (isset(auth()->user()->id)) {
									$is_enrolled = DB::table('enrollments')
										->where('user_id', auth()->user()->id)
										->where('course_id', $course_details->id)
										->exists();

									$in_cart = DB::table('cart_items')
										->where('user_id', auth()->user()->id)
										->where('course_id', $course_details->id)
										->exists();

									$in_wishlist = DB::table('wishlists')
										->where('user_id', auth()->user()->id)
										->where('course_id', $course_details->id)
										->exists();

									$pending_course_for_payment = DB::table('offline_payments')
										->where('user_id', auth()->user()->id)
										->where('status', 0)
										->first();

									$pending_course = $pending_course_for_payment ? json_decode($pending_course_for_payment->items, true) : [];
								}
							?>
						
							
						</div>
                        <a href="<?php echo e(route('courses')); ?>" class="btn-black1" style="background-color: #F3FF6C; color: #006600;"><?php echo e(get_phrase('Get Courses')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Hero Area End -->

    <!-- Software Development Area Start -->


    <?php if($stordetails = json_decode(get_homepage_settings('development'))): ?>
        <?php
            function highlightLastWord($text)
            {
                $words = explode(' ', $text);
                if (count($words) > 1) {
                    $lastWord = array_pop($words);
                    return implode(' ', $words) . ' <span class="highlight">' . $lastWord . '</span>';
                }
                return '<span class="highlight">' . $text . '</span>';
            }
        ?>
        <section>
            <div class="container">
                <div class="row row-20 mb-80 align-items-center">
                    <div class="col-lg-6">
                        <div class="software-development-banner">
                            <?php if(isset($stordetails->image)): ?>
                                <img src="<?php echo e(asset('uploads/home_page_image/development/' . $stordetails->image)); ?>" alt="">
                            <?php else: ?>
                                <img src="<?php echo e(asset('assets/frontend/default/image/soft-dev-banner.webp')); ?>" alt="">
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="software-development-details">
                            <h2 class="title"><?php echo removeScripts(highlightLastWord($stordetails->title)); ?></h2>
                            <p class="info mb-20"><?php echo e($stordetails->description); ?></p>
                            <a href="<?php echo e(route('about.us')); ?>" class="btn-black-arrow1">
                                <span><?php echo e(get_phrase('Learn More')); ?></span>
                                <i class="fi-rr-angle-small-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>

    <!-- Software Development Area End -->

    <!-- Learning Coding Area Start -->
    <section>
        <div class="container">
            <!-- Section Title -->
            <div class="row">
                <div class="col-md-12">
                    <div class="dev-section-title">
                        <h1 class="title mb-20"><?php echo e(get_phrase('PALSARH ensures')); ?> <span class="highlight"><?php echo e(get_phrase('JUSTICE')); ?></span> <?php echo e(get_phrase('to all')); ?></h1>
                        <p class="info"><?php echo e(get_phrase("Power Academy of Legal Services and Research Hub (PALSARH) is meant to ensure ‘JUSTICE’ that is accessible to all through competent legal education and legal aid.")); ?></p>
                    </div>
                </div>
            </div>
            <div class="row row-20 mb-100 justify-content-center">
                <!-- Card -->
                <div class="col-lg-4 col-md-6">
                    <div class="learning-coding-card pt-3">
                        <div class="banner mb-5">
                            <img src="<?php echo e(asset('assets/frontend/default/image/learnig-coding-banner1.webp')); ?>" alt="">
                        </div>
                        <h4 class="title"><?php echo e(get_phrase('Study Material')); ?></h4>
                        <p class="info"><?php echo e(get_phrase("Our resources are tailored to support your learning journey, providing you with high-quality content, detailed explanations, and practice materials. Whether you're preparing for exams or simply enhancing your knowledge, our study material is here to guide you every step of the way.")); ?></p>
						<div class="text-center">
							<a href="https://palsarh.in/pages/books/" class="btn-black-arrow1" style="display: block !important; margin: 20px auto 0 auto;">
									<span><?php echo e(get_phrase('Learn More')); ?></span>
									<i class="fi-rr-angle-small-right"></i>
							</a>
						</div>
					</div>
                </div>
                <!-- Card -->
                <div class="col-lg-4 col-md-6">
                    <div class="learning-coding-card pt-3">
                        <div class="banner mb-5">
                            <img src="<?php echo e(asset('assets/frontend/default/image/learnig-coding-banner2.webp')); ?>" alt="">
                        </div>
                        <h4 class="title"><?php echo e(get_phrase('Faculty')); ?></h4>
                        <p class="info"><?php echo e(get_phrase("Our expert faculty in Legal Structure brings deep knowledge and practical insights, ensuring an engaging learning experience. They guide students to excel in exams while inspiring them to uphold justice and contribute to society.")); ?></p>
						<div class="text-center">
							<a href="https://palsarh.in/pages/our-team/" class="btn-black-arrow1" style="display: block !important; margin: 20px auto 0 auto;">
									<span><?php echo e(get_phrase('Learn More')); ?></span>
									<i class="fi-rr-angle-small-right"></i>
							</a>
						</div>
					</div>
                </div>
                <!-- Card -->
                <div class="col-lg-4 col-md-6">
                    <div class="learning-coding-card pt-3">
                        <div class="banner mb-5">
                            <img src="<?php echo e(asset('assets/frontend/default/image/learnig-coding-banner3.webp')); ?>" alt="">
                        </div>
                        <h4 class="title"><?php echo e(get_phrase('Available Courses')); ?></h4>
                        <p class="info"><?php echo e(get_phrase("Explore our diverse range of courses designed to enhance your skills and career prospects. From IT training and digital marketing to web development and mobile app programming, our expert-led courses cater to beginners and professionals alike. Enroll today and take the next step toward success!")); ?></p>
						<div class="text-center">
							<a href="<?php echo e(url('courses')); ?>" class="btn-black-arrow1" style="display: block !important; margin: 20px auto 0 auto;">
									<span><?php echo e(get_phrase('Learn More')); ?></span>
									<i class="fi-rr-angle-small-right"></i>
							</a>
						</div>
					</div>
                </div>
            </div>
        </div>
    </section>
    <!-- Learning Coding Area End -->

    <!-- Pick A Course Area Start -->
    <section>
        <div class="container">
            <!-- Section Title -->
            <div class="row">
                <div class="col-md-12">
                    <div class="dev-section-title">
                        <h1 class="title mb-20"><?php echo e(get_phrase('Pick A Course To')); ?> <span class="highlight"><?php echo e(get_phrase('Get Started')); ?></span></h1>
                        <p class="info"><?php echo e(get_phrase("The industry's standard dummy text ever since the  unknown printer took a galley of type and scrambled")); ?></p>
                    </div>
                </div>
            </div>
            <div class="row row-20 mb-110">
                <?php
                    $featured_courses = DB::table('courses')->where('status', 'active')->latest('id')->get();
                ?>
                <?php $__currentLoopData = $featured_courses->take(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6">
                        <a href="<?php echo e(route('course.details', $row->slug)); ?>" class="dev-course-card-link">
                            <div class="dev-course-card">
                                <div class="banner">
                                    <img src="<?php echo e(get_image($row->thumbnail)); ?>" alt="banner">
                                </div>
                                <?php
                                    $ratings = DB::table('reviews')
                                        ->where('course_id', $row->id)
                                        ->pluck('rating')
                                        ->toArray();
                                    $average_rating = count($ratings) > 0 ? array_sum($ratings) / count($ratings) : 0;
                                    $full_stars = floor($average_rating);
                                    $has_half_star = $average_rating - $full_stars >= 0.5;
                                    $review_count = count($ratings);
                                ?>
                                <div class="dev-course-card-body">
                                    <h5 class="title ellipsis-line-2"><?php echo e(ucfirst($row->title)); ?></h5>
                                    <div class="reviews d-flex align-items-center">
                                        <?php if($review_count > 0): ?>
                                            <div class="ratings d-flex align-items-center">
                                                <?php for($i = 0; $i < 5; $i++): ?>
                                                    <?php if($i < $full_stars): ?>
                                                        <img src="<?php echo e(asset('assets/frontend/default/image/star-yellow-14.svg')); ?>" alt="Full Star">
                                                    <?php elseif($i == $full_stars && $has_half_star): ?>
                                                        <img src="<?php echo e(asset('assets/frontend/default/image/star-yellow-half-14.svg')); ?>" alt="Half Star">
                                                    <?php else: ?>
                                                        <img src="<?php echo e(asset('assets/frontend/default/image/star.svg')); ?>" alt="Empty Star">
                                                    <?php endif; ?>
                                                <?php endfor; ?>
                                            </div>
                                            <p class="total fw-500"><?php echo e($review_count); ?> <?php echo e(get_phrase('Reviews')); ?></p>
                                        <?php endif; ?>
                                    </div>

                                    <?php if(isset($row->is_paid) && $row->is_paid == 0): ?>
                                        <p class="price"><?php echo e(get_phrase('Free')); ?></p>
                                    <?php elseif(isset($row->discount_flag) && $row->discount_flag == 1): ?>
                                        <p class="price">
                                            <del class="fs-14px text-secondary"><?php echo e(currency($row->price)); ?></del>
                                            <?php echo e(currency(number_format($row->discounted_price, 2))); ?>

                                        </p>
                                    <?php else: ?>
                                        <p class="price"><?php echo e(currency(number_format($row->price, 2))); ?></p>
                                    <?php endif; ?>

                                    <div class="leason-student d-flex align-items-center">
                                        <div class="leasons-students d-flex align-items-center">
                                            <i class="fi-rr-book-open-cover"></i>
                                            <p class="total fw-500"><?php echo e(lesson_count($row->id)); ?><?php echo e(get_phrase('lessons')); ?></p>
                                        </div>
                                        <div class="leasons-students d-flex align-items-center">
                                            <i class="fi-rr-users"></i>
                                            <p class="total fw-500"><?php echo e(course_enrollments($row->id)); ?> <?php echo e(get_phrase('Students')); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php if(count($featured_courses) > 4): ?>
                    <!-- Button  -->
                    <div class="col-xl-12">
                        <div class="dev-course-btn-area d-flex justify-content-center">
                            <a href="<?php echo e(route('courses')); ?>" class="btn-black-arrow1">
                                <span><?php echo e(get_phrase('View More')); ?></span>
                                <i class="fi-rr-angle-small-right"></i>
                            </a>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <!-- Pick A Course Area End -->

    <!-- Programming Ebook Area Start -->
    <?php if(get_frontend_settings('mobile_app_link')): ?>
        <section class="programming-ebook-section mb-110">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="programming-ebook-area d-flex align-items-center justify-content-between">
                            <div class="programming-ebook-banner">
                                <img src="<?php echo e(asset('assets/frontend/default/image/programming-ebook-banner.webp')); ?>" alt="">
                            </div>
                            <div class="programming-ebook-details">
                                <h2 class="title"><?php echo e(get_phrase('Download our mobile app, start learning')); ?> <span class="highlight"><?php echo e(get_phrase('Academy')); ?></span></h2>
                                <p class="info mb-30"><?php echo e(get_phrase("The industry's standard dummy text ever since the  unknown printer took a galley of type and scrambled")); ?></p>
                                <a href="<?php echo e(get_frontend_settings('mobile_app_link')); ?>" class="btn-black-arrow1">
                                    <span><?php echo e(get_phrase('Download Now')); ?></span>
                                    <i class="fi-rr-angle-small-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!-- Programming Ebook Area End -->

    <!-- Ask Question Area Start -->
    <section>
        <div class="container">
            <!-- Section Title -->
            <div class="row">
                <div class="col-md-12">
                    <div class="dev-section-title">
                        <h1 class="title"><?php echo e(get_phrase('Frequently Asked')); ?> <span class="highlight"><?php echo e(get_phrase('Questions')); ?></span></h1>
                    </div>
                </div>
            </div>
            <!-- QNA Accordion -->
            <div class="row mb-100">
                <div class="col-md-12">
                    <div class="accordion qna-three-accordion" id="accordionExample4">
                        <?php
                            $faqs = count(json_decode(get_frontend_settings('website_faqs'), true)) > 0 ? json_decode(get_frontend_settings('website_faqs'), true) : [['question' => '', 'answer' => '']];
                        ?>
                        <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="accordion-item">
                                <h2 class="accordion-header" id="<?php echo e($key); ?>">
                                    <button class="accordion-button <?php echo e($key == 0 ? '' : 'collapsed'); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#qnaOne<?php echo e($key); ?>" aria-expanded="true" aria-controls="qnaOne">
                                        <?php echo e($faq['question']); ?>

                                    </button>
                                </h2>
                                <div id="qnaOne<?php echo e($key); ?>" class="accordion-collapse collapse px-0  <?php echo e($key == 0 ? 'show' : ''); ?>" data-bs-parent="#accordionExample4" aria-labelledby="<?php echo e($key); ?>">
                                    <div class="accordion-body">
                                        <p class="answer"><?php echo e($faq['answer']); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Ask Question Area End -->

    <!-- Student Testimonials Area Start -->
    <section>
        <div class="container">
            <!-- Section Title -->
            <div class="row">
                <div class="col-md-12">
                    <div class="dev-section-title">
                        <h1 class="title mb-20"><?php echo e(get_phrase('What Our')); ?> <span class="highlight"><?php echo e(get_phrase('Students')); ?></span> <?php echo e(get_phrase('Have To Say')); ?></h1>
                        <p class="info"><?php echo e(get_phrase("The industry's standard dummy text ever since the  unknown printer took a galley of type and scrambled")); ?></p>
                    </div>
                </div>
            </div>
            <!-- Testimonials -->
            <div class="row mb-100">
                <div class="col-md-12">
                    <div class="swiper dev-student-swiper">
                        <div class="swiper-wrapper">
                            <?php
                                $reviews = DB::table('user_reviews')->get();
                            ?>
                            <?php $__currentLoopData = $reviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $review): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $userDetails = App\Models\User::where('id', $review->user_id)->firstOrNew();
                                ?>
                                <div class="swiper-slide">
                                    <div class="dev-student-testimonial">
                                        <div class="ratings d-flex align-items-center">
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= $review->rating): ?>
                                                    <img src="<?php echo e(asset('assets/frontend/default/image/star-yellow-14.svg')); ?>" alt="">
                                                <?php else: ?>
                                                    <img src="<?php echo e(asset('assets/frontend/default/image/star.svg')); ?>" alt="">
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                        </div>
                                        <p class="feedback"><span class="bold"><?php echo e($review->review); ?></p>
                                        <div class="profile-wrap d-flex align-items-center">
                                            <!--<div class="profile">
                                                <img src="<?PHP //echo get_image_by_id($userDetails->id); ?>" alt="">
                                            </div>-->
                                            <div class="name-role">
                                                <h5 class="name"><?php echo e($review->student_name); ?></h5>
                                                <p class="role"><?php echo e(get_phrase('Student')); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                        <div class="swiper-button-wrap d-flex align-items-center justify-content-center">
                            <div class="swiper-button-prev">
                                <i class="fi-rr-arrow-alt-left ms-3 ps-1"></i>
                            </div>
                            <div class="swiper-button-next">
                                <i class="fi-rr-arrow-alt-right ms-3 ps-1"></i>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Student Testimonials Area End -->

    <!-- News Blog Area Start -->
    <?php if(get_frontend_settings('blog_visibility_on_the_home_page')): ?>
        <section>
            <div class="container">
                <!-- Section Title -->
                <div class="row">
                    <div class="col-md-12">
                        <div class="dev-section-title">
                            <h1 class="title mb-20"><?php echo e(get_phrase('Get News with')); ?> <span class="highlight"><?php echo e(get_phrase('Academy')); ?></span></h1>
                            <p class="info"><?php echo e(get_phrase("The industry's standard dummy text ever since the  unknown printer took a galley of type and scrambled")); ?></p>
                        </div>
                    </div>
                </div>
                <div class="row row-20 mb-100">
                    <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-4 col-md-6 col-sm-6">
                            <a href="<?php echo e(route('blog.details', $blog->slug)); ?>" class="dev-news-link">
                                <div class="dev-news-card">
                                    <div class="banner">
                                        <img src="<?php echo e(get_image($blog->thumbnail)); ?>" alt="">
                                    </div>
                                    <div class="dev-news-card-body">
                                        <h5 class="ellipsis-line-2 title mb-12"><?php echo e(ucfirst($blog->title)); ?></h5>
                                        <div class="date-comments flex-wrap mb-3 d-flex align-items-center">
                                            <div class="date-wrap d-flex align-items-center">
                                                <img src="<?php echo e(asset('assets/frontend/default/image/calendar-black-16.svg')); ?>" alt="">
                                                <p class="value"><?php echo e($blog->created_at->format('d M, Y')); ?></p>
                                            </div>
                                            <div class="comment-wrap mt-0 d-flex align-items-center">
                                                <img src="<?php echo e(asset('assets/frontend/default/image/messages-black-16.svg')); ?>" alt="">
                                                <p class="value"><?php echo e(count_comments_by_blog_id($blog->id)); ?></p>
                                            </div>
                                        </div>
                                        <p class="info ellipsis-line-2"><?php echo e(ellipsis(strip_tags($blog->description), 160)); ?></p>

                                        <p class="text-dark mt-3 text-dev-warning"><?php echo e(get_phrase('Read More')); ?> <i class="fi-br-angle-small-right"></i></p>
                                    </div>
                                </div>
                            </a>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					<div class="text-center">
							<a href="<?php echo e(url('blogs')); ?>" class="btn-black-arrow1" style="display: block !important; margin: 20px auto 0 auto;">
									<span><?php echo e(get_phrase('Read More')); ?></span>
									<i class="fi-rr-angle-small-right"></i>
							</a>
						</div>
                </div>
            </div>
        </section>
    <?php endif; ?>
    <!-- News Blog Area End -->


    <!-- Vertically centered modal -->
    <div class="modal fade-in-effect" id="promoVideo" tabindex="-1" aria-labelledby="promoVideoLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content">
                <div class="modal-body bg-dark">
                    <link rel="stylesheet" href="<?php echo e(asset('assets/global/plyr/plyr.css')); ?>">

                    <?php if(get_frontend_settings('promo_video_provider') == 'youtube'): ?>
                        <div class="plyr__video-embed" id="promoPlayer">
                            <iframe height="500" src="<?php echo e(get_frontend_settings('promo_video_link')); ?>?origin=https://plyr.io&amp;iv_load_policy=3&amp;modestbranding=1&amp;playsinline=1&amp;showinfo=0&amp;rel=0&amp;enablejsapi=1" allowfullscreen allowtransparency allow="autoplay"></iframe>
                        </div>
                    <?php elseif(get_frontend_settings('promo_video_provider') == 'vimeo'): ?>
                        <div class="plyr__video-embed" id="promoPlayer">
                            <iframe height="500" id="promoPlayer" src="https://player.vimeo.com/video/<?php echo e(get_frontend_settings('promo_video_link')); ?>?loop=false&amp;byline=false&amp;portrait=false&amp;title=false&amp;speed=true&amp;transparent=0&amp;gesture=media" allowfullscreen allowtransparency allow="autoplay"></iframe>
                        </div>
                    <?php else: ?>
                        <video id="promoPlayer" playsinline controls>
                            <source src="<?php echo e(get_frontend_settings('promo_video_link')); ?>" type="video/mp4">
                        </video>
                    <?php endif; ?>

                    <script src="<?php echo e(asset('assets/global/plyr/plyr.js')); ?>"></script>
                    <script>
                        "use strict";
                        var promoPlayer = new Plyr('#promoPlayer');
                    </script>

                </div>
            </div>
        </div>
    </div>

    <script>
        "use strict";
        const myModalEl = document.getElementById('promoVideo')
        myModalEl.addEventListener('hidden.bs.modal', event => {
            promoPlayer.pause();
            $('#promoVideo').toggleClass('in');
        });
        myModalEl.addEventListener('shown.bs.modal', event => {
            promoPlayer.play();
            $('#promoVideo').toggleClass('in');
        });
    </script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.default', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home1/cwmsozbb/public_html/resources/views/components/home_permanent_templates/development.blade.php ENDPATH**/ ?>