<?php if(isset($lesson_details->lesson_type)): ?>
    <?php if($lesson_details->lesson_type == 'text'): ?>
        <div class="course-video-area border-primary">
            <div class="text_show">
                <?php echo removeScripts($lesson_details->attachment); ?>

            </div>
        </div>
    <?php elseif($lesson_details->lesson_type == 'video-url'): ?>
        <div class="course-video-area border-primary border">
            <!-- Video -->
            <div class="course-video-wrap">
                <div id="player">
                    <iframe src="<?php echo e($lesson_details->lesson_src); ?>?origin=https://plyr.io&amp;iv_load_policy=3&amp;modestbranding=1&amp;playsinline=1&amp;showinfo=0&amp;rel=0&amp;enablejsapi=1" allowfullscreen allowtransparency allow="autoplay"></iframe>
                </div>
                <?php echo $__env->make('course_player.player_config', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
        </div>
    <?php elseif($lesson_details->lesson_type == 'system-video'): ?>
        <?php
            $watermark_type = get_player_settings('watermark_type');
            $lesson_video = $lesson_details->lesson_src;
            if ($watermark_type == 'ffmpeg') {
                $origin = dirname($lesson_details->lesson_src);
                $dir = $origin . '/watermark';
                $file = str_replace($origin, '', $lesson_details->lesson_src);
                $lesson_video = "{$dir}{$file}";
            }
        ?>
        <div class="course-video-area border-primary border">
            <!-- Video -->
            <div class="course-video-wrap">
                <div class=" bd-r-10 mb-16 position-relative bg-light custom-system-video">
                    <video id="player" playsinline controls>
                        <source src="<?php echo e(asset($lesson_details->lesson_src)); ?>" type="video/mp4">
                    </video>
                    <?php echo $__env->make('course_player.player_config', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
            </div>
        </div>
    <?php elseif($lesson_details->lesson_type == 'image'): ?>
        <?php
            $img = asset('uploads/lesson_file/attachment/' . $lesson_details->attachment);
        ?>
        <img width="100%" class="max-w-auto" height="auto" src="<?php echo e($img); ?>" />
    <?php elseif($lesson_details->lesson_type == 'vimeo-url' && $lesson_details->video_type == 'vimeo'): ?>
        <?php
            $video_url = $lesson_details->lesson_src;
            $video_id = explode('https://vimeo.com/', $video_url);
            $video_id = str_replace('https://vimeo.com/', '', $video_url);
        ?>

        <div class="course-video-area border-primary border">
            <!-- Video -->
            <div class="course-video-wrap">
                <div id="player">
                    <iframe height="500" src="https://player.vimeo.com/video/<?php echo e($video_id); ?>?loop=false&amp;byline=false&amp;portrait=false&amp;title=false&amp;speed=true&amp;transparent=0&amp;gesture=media" allowfullscreen allowtransparency allow="autoplay"></iframe>
                    <?php echo $__env->make('course_player.player_config', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
            </div>
        </div>
    <?php elseif($lesson_details->lesson_type == 'google_drive'): ?>
        <?php
            $video_url = $lesson_details->lesson_src;
            $url_array_1 = explode('/', $video_url . '/');
            $url_array_2 = explode('=', $video_url);
            $video_id = null;
            if ($url_array_1[4] == 'd'):
                $video_id = $url_array_1[5];
            else:
                $video_id = $url_array_2[1];
            endif;
        ?>
        <div class="course-video-area border-primary border">
            <!-- Video -->
            <div class="course-video-wrap">
                <video width="100%" height="680" id="player" playsinline controls>
                    <source class="" src="https://www.googleapis.com/drive/v3/files/<?php echo e($video_id); ?>?alt=media&key=<?php echo e(get_settings('youtube_api_key')); ?>" type="video/mp4">
                </video>
                <?php echo $__env->make('course_player.player_config', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
        </div>
    <?php elseif($lesson_details->lesson_type == 'html5'): ?>
        <div class="course-video-area border-primary border">
            <!-- Video -->
            <div class="course-video-wrap">
                <video width="100%" height="680" id="player" playsinline controls>
                    <source class="remove_video_src" src="<?php echo e($lesson_details->lesson_src); ?>" type="video/mp4">
                </video>
                <?php echo $__env->make('course_player.player_config', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>
        </div>
    <?php elseif($lesson_details->lesson_type == 'document_type'): ?>
        <?php if($lesson_details->attachment_type == 'pdf'): ?>
            <iframe class="embed-responsive-item" width="100%" src="<?php echo e(asset('uploads/lesson_file/attachment/' . $lesson_details->attachment)); ?>" allowfullscreen></iframe>
        <?php elseif($lesson_details->attachment_type == 'doc' || $lesson_details->attachment_type == 'ppt'): ?>
            <iframe class="embed-responsive-item" width='100%' src="https://view.officeapps.live.com/op/embed.aspx?src=<?php echo e(asset('uploads/lesson_file/attachment/' . $lesson_details->attachment)); ?>" frameborder='0'></iframe>
        <?php elseif($lesson_details->attachment_type == 'txt'): ?>
            <iframe class="embed-responsive-item" width='100%' src="<?php echo e(asset('uploads/lesson_file/attachment/' . $lesson_details->attachment)); ?>" frameborder='0'></iframe>
        <?php endif; ?>
    <?php elseif($lesson_details->lesson_type == 'quiz'): ?>
        <div class="course-video-area border-primary pb-5">
            <?php echo $__env->make('course_player.quiz.index', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>
    <?php else: ?>
        <iframe class="embed-responsive-item" width="100%" src="<?php echo e($lesson_details->lesson_src); ?>" allowfullscreen></iframe>
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH /home1/cwmsozbb/public_html/resources/views/course_player/player_page.blade.php ENDPATH**/ ?>