<div>

    <h4 class="title mt-4 mb-3"><?php echo e(get_phrase('Recaptcha settings')); ?></h4>
    <form action="<?php echo e(route('admin.website.settings.update')); ?>" method="post" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <input type="hidden" name="type" value="recaptcha_settings">
        <div class="fpb-7 mb-3">
            <label class="form-label ol-form-label"><?php echo e(get_phrase('Recaptcha status')); ?><span class="required">*</span></label><br>
            <input class="form-check-input" type="radio" id="recaptcha_active" value="1" name="recaptcha_status" <?php if(get_frontend_settings('recaptcha_status') == 1): ?> checked <?php endif; ?>>
            <label class="form-label ol-form-label" for="recaptcha_active"><?php echo e(get_phrase('Active')); ?></label>
            &nbsp;&nbsp;
            <input class="form-check-input" type="radio" id="recaptcha_inactive" value="0" name="recaptcha_status"<?php if(get_frontend_settings('recaptcha_status') == 0): ?> checked <?php endif; ?>>
            <label class="form-label ol-form-label" for="recaptcha_inactive"><?php echo e(get_phrase('Inactive')); ?></label>
        </div>

        <div class="fpb-7 mb-3">
            <label class="form-label ol-form-label" for="recaptcha_sitekey"><?php echo e(get_phrase('Recaptcha sitekey')); ?> (v2)<span class="required">*</span></label>
            <input type="text" name = "recaptcha_sitekey" id = "recaptcha_sitekey" class="form-control ol-form-control" value="<?php echo e(get_frontend_settings('recaptcha_sitekey')); ?>" required>
        </div>

        <div class="fpb-7 mb-3">
            <label class="form-label ol-form-label" for="recaptcha_secretkey"><?php echo e(get_phrase('Recaptcha secretkey')); ?>(v2)<span class="required">*</span></label>
            <input type="text" name = "recaptcha_secretkey" id = "recaptcha_secretkey" class="form-control ol-form-control" value="<?php echo e(get_frontend_settings('recaptcha_secretkey')); ?>" required>
        </div>

        <div class="row justify-content-center">
            <div class="col-md-4">
                <button type="submit" class="eBtn eBtn-blue w-100"><?php echo e(get_phrase('Update recaptcha settings')); ?></button>
            </div>
        </div>
    </form>
</div>
<?php /**PATH /home1/cwmsozbb/public_html/resources/views/admin/setting/recaptcha.blade.php ENDPATH**/ ?>