
<?php $__env->startPush('title', get_phrase('Offline payments')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Mani section header and breadcrumb -->
    <div class="ol-card radius-8px print-d-none">
        <div class="ol-card-body px-20px my-3 py-4">
            <div class="d-flex align-items-center justify-content-between flex-md-nowrap flex-wrap gap-3">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <span><?php echo e(get_phrase('Offline payments')); ?></span>
                </h4>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="ol-card">
                <div class="ol-card-body p-3">
                    <div class="row print-d-none row-gap-3 mb-3 mt-3">
                        <div class="col-md-6 d-flex align-items-center gap-3">
                            <div class="custom-dropdown">
                                <button class="dropdown-header btn ol-btn-light">
                                    <?php echo e(get_phrase('Export')); ?>

                                    <i class="fi-rr-file-export ms-2"></i>
                                </button>
                                <ul class="dropdown-list">
                                    <li>
                                        <a class="dropdown-item" href="#" onclick="downloadPDF('.print-table', 'offline-payments')"><i class="fi-rr-file-pdf"></i>
                                            <?php echo e(get_phrase('PDF')); ?></a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="#" onclick="window.print();"><i class="fi-rr-print"></i> <?php echo e(get_phrase('Print')); ?></a>
                                    </li>
                                </ul>
                            </div>

                            <div class="custom-dropdown dropdown-filter <?php if(!isset($_GET) || (isset($_GET) && count($_GET) == 0)): ?>  <?php endif; ?>">
                                <button class="dropdown-header btn ol-btn-light">
                                    <i class="fi-rr-filter me-2"></i>
                                    <?php echo e(get_phrase('Filter')); ?>


                                    <?php if(isset($_GET) && count($_GET)): ?>
                                        <span class="text-12px">
                                            (<?php echo e(count($_GET)); ?>)
                                        </span>
                                    <?php endif; ?>
                                </button>
                                <ul class="dropdown-list w-250px">
                                    <li>
                                        <form id="filter-dropdown" action="<?php echo e(route('admin.offline.payments')); ?>" method="get">
                                            <div class="filter-option d-flex flex-column gap-3">
                                                <div>
                                                    <label for="eDataList" class="form-label ol-form-label"><?php echo e(get_phrase('Category')); ?></label>
                                                    <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="status" data-placeholder="Type to search...">
                                                        <option value="all"><?php echo e(get_phrase('All')); ?></option>
                                                        <option value="pending" <?php if(isset($_GET['status']) && $_GET['status'] == 'pending'): ?> selected <?php endif; ?>><?php echo e(get_phrase('Pending')); ?></option>
                                                        <option value="approved" <?php if(isset($_GET['status']) && $_GET['status'] == 'approved'): ?> selected <?php endif; ?>><?php echo e(get_phrase('Approved')); ?></option>
                                                        <option value="suspended" <?php if(isset($_GET['status']) && $_GET['status'] == 'suspended'): ?> selected <?php endif; ?>><?php echo e(get_phrase('Suspended')); ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="filter-button d-flex justify-content-end align-items-center mt-3">
                                                <button type="submit" class="ol-btn-primary"><?php echo e(get_phrase('Apply')); ?></button>
                                            </div>
                                        </form>
                                    </li>
                                </ul>
                            </div>

                            <?php if(isset($_GET) && count($_GET) > 0): ?>
                                <a href="<?php echo e(route('admin.offline.payments')); ?>" class="me-2" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Clear')); ?>"><iclass="fi-rr-cross-circle"></iclass=></a>
                            <?php endif; ?>
                        </div>

                        <div class="col-md-6">

                        </div>
                    </div>

                    <!-- Table -->
                    <?php if(count($payments) > 0): ?>
                        <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center gr-15 flex-wrap">
                            <p class="admin-tInfo">
                                <?php echo e(get_phrase('Showing') . ' ' . count($payments) . ' ' . get_phrase('of') . ' ' . $payments->total() . ' ' . get_phrase('data')); ?>

                            </p>
                        </div>
                        <div class="table-responsive course_list" id="course_list">
                            <table class="eTable eTable-2 print-table table">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col"><?php echo e(get_phrase('User')); ?></th>
                                        <th scope="col"><?php echo e(get_phrase('Items')); ?></th>
                                        <th scope="col"><?php echo e(get_phrase('Total')); ?></th>
                                        <th scope="col"><?php echo e(get_phrase('Issue date')); ?></th>
                                        <th scope="col"><?php echo e(get_phrase('Payment info')); ?></th>
                                        <th scope="col"><?php echo e(get_phrase('Status')); ?></th>
                                        <th scope="col" class="print-d-none"><?php echo e(get_phrase('Options')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <th scope="row">
                                                <p class="row-number"><?php echo e($key + 1); ?></p>
                                            </th>

                                            <td>
                                                <div class="dAdmin_profile d-flex align-items-center min-w-200px">
                                                    <div class="dAdmin_profile_name">
                                                        <h4 class="title fs-14px">
                                                            <?php echo e(get_user_info($payment->user_id)->name); ?>

                                                        </h4>
                                                        <p class="sub-title text-12px"><?php echo e(get_user_info($payment->user_id)->email); ?></p>
                                                        <p class="sub-title text-12px"><?php echo e(get_phrase('Phone')); ?>: <?php echo e(get_user_info($payment->user_id)->phone); ?></p>
                                                    </div>
                                                </div>
                                            </td>

                                            <td>
                                                <div class="dAdmin_profile d-flex align-items-center min-w-200px">
                                                    <div class="dAdmin_profile_name">
                                                        <?php if($payment->item_type == 'course'): ?>
                                                            <?php $__currentLoopData = App\Models\Course::whereIn('id', json_decode($payment->items, true))->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $course): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <p class="sub-title text-12px">
                                                                    <a href="<?php echo e(route('course.details', slugify($course->title))); ?>" class="text-muted me-3"><?php echo e($course->title); ?> </a>
                                                                </p>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endif; ?>

                                                        <?php if($payment->item_type == 'bootcamp'): ?>
                                                            <?php $__currentLoopData = App\Models\Bootcamp::whereIn('id', json_decode($payment->items, true))->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bootcamp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <p class="sub-title text-12px">
                                                                    <a href="<?php echo e(route('bootcamp.details', ['slug' => slugify($bootcamp->title)])); ?>" class="text-muted me-3"><?php echo e($bootcamp->title); ?> </a>
                                                                </p>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endif; ?>

                                                        <?php if($payment->item_type == 'package'): ?>
                                                            <?php $__currentLoopData = App\Models\TeamTrainingPackage::whereIn('id', json_decode($payment->items, true))->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <p class="sub-title text-12px">
                                                                    <a href="<?php echo e(route('team.package.details', ['slug' => $package->slug])); ?>" class="text-muted me-3"><?php echo e($package->title); ?> </a>
                                                                </p>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </td>

                                            <td>
                                                <div class="sub-title2 text-12px">
                                                    <?php echo e(currency($payment->total_amount)); ?>

                                                </div>
                                            </td>

                                            <td>
                                                <div class="sub-title2 text-12px">
                                                    <p><?php echo e(date('d-M-y', strtotime($payment->created_at))); ?></p>
                                                </div>
                                            </td>

                                            <td>
                                                <a class="dropdown-item btn ol-btn-primary px-2 py-1" href="<?php echo e(route('admin.offline.payment.doc', $payment->id)); ?>"><i class="fi-rr-cloud-download"></i> <?php echo e(get_phrase('Download')); ?></a>
                                            </td>

                                            <td>
                                                <?php if($payment->status == 1): ?>
                                                    <span class="badge bg-success"><?php echo e(get_phrase('Accepted')); ?></span>
                                                <?php elseif($payment->status == 2): ?>
                                                    <span class="badge bg-danger"><?php echo e(get_phrase('Suspended')); ?></span>
                                                <?php else: ?>
                                                    <span class="badge bg-warning"><?php echo e(get_phrase('Pending')); ?></span>
                                                <?php endif; ?>
                                            </td>

                                            <td class="print-d-none">
                                                <div class="dropdown ol-icon-dropdown ol-icon-dropdown-transparent">
                                                    <button class="btn ol-btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                        <span class="fi-rr-menu-dots-vertical"></span>
                                                    </button>
                                                    <ul class="dropdown-menu">
                                                        <li><a class="dropdown-item" href="<?php echo e(route('admin.offline.payment.doc', $payment->id)); ?>"><?php echo e(get_phrase('Download')); ?></a>
                                                        </li>
                                                        <li><a class="dropdown-item" href="<?php echo e(route('admin.offline.payment.accept', $payment->id)); ?>"><?php echo e(get_phrase('Accept')); ?></a>
                                                        </li>
                                                        <li><a class="dropdown-item" href="#" onclick="confirmModal('<?php echo e(route('admin.offline.payment.decline', $payment->id)); ?>')"><?php echo e(get_phrase('Decline')); ?></a>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else: ?>
                        <?php echo $__env->make('admin.no_data', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <?php endif; ?>
                    <!-- Data info and Pagination -->
                    <?php if(count($payments) > 0): ?>
                        <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center gr-15 flex-wrap">
                            <p class="admin-tInfo">
                                <?php echo e(get_phrase('Showing') . ' ' . count($payments) . ' ' . get_phrase('of') . ' ' . $payments->total() . ' ' . get_phrase('data')); ?>

                            </p>
                            <?php echo e($payments->links()); ?>

                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/admin/offline_payments/index.blade.php ENDPATH**/ ?>