<style>
    .question {
        min-height: auto !important;
    }

    .accordion-button::after {
        background-size: 14px;
    }

    .accordion-button:focus {
        box-shadow: none
    }

    .accordion-button:not(.collapsed) {
        background: #f4f7fe;
    }
</style>
<div class="accordion" id="accordionExample">
    <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="accordion-item">
            <h2 class="accordion-header">
                <button class="accordion-button collapsed fs-14px fw-500" type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapse-<?php echo e($result->id); ?>" aria-expanded="false"
                    aria-controls="collapse-<?php echo e($result->id); ?>">
                    <?php echo e(get_phrase('Attempt ')); ?><?php echo e(++$key); ?>

                    <span class="ms-5"><?php echo e(date('d M, Y H:i', strtotime($result->created_at))); ?></span>
                </button>
            </h2>
            <div id="collapse-<?php echo e($result->id); ?>" class="accordion-collapse collapse"
                data-bs-parent="#accordionExample">
                <div class="accordion-body">
                    <div class="result">
                        <?php
                            $submits = $result->submits ? json_decode($result->submits, true) : [];
                            $correct_answers = $result->correct_answer
                                ? json_decode($result->correct_answer, true)
                                : [];
                            $wrong_answers = $result->wrong_answer ? json_decode($result->wrong_answer, true) : [];
                        ?>

                        <div class="row mb-3">
                            <div class="col-md-6">
                                <p><?php echo e(get_phrase('Duration : ')); ?>

                                    <?php $duration = explode(':', $quiz->duration); ?>
                                    <?php echo e($duration[0]); ?> <?php echo e(get_phrase('Hour')); ?>

                                    <?php echo e($duration[1]); ?> <?php echo e(get_phrase('Minute')); ?>

                                    <?php echo e($duration[1]); ?> <?php echo e(get_phrase('Second')); ?>

                                </p>
                                <p><?php echo e(get_phrase('Total Mark : ')); ?><?php echo e($quiz->total_mark); ?></p>
                                <p><?php echo e(get_phrase('Pass Mark : ')); ?><?php echo e($quiz->pass_mark); ?></p>
                            </div>
                            <div class="col-md-6">
                                <p><?php echo e(get_phrase('Correct Answer : ')); ?><?php echo e(count($correct_answers)); ?></p>
                                <p><?php echo e(get_phrase('Wrong Answer : ')); ?><?php echo e(count($wrong_answers)); ?></p>
                                <p><?php echo e(get_phrase('Result : ')); ?>

                                    <?php if(count($correct_answers) >= $quiz->pass_mark): ?>
                                        <span class="text-success"><?php echo e(get_phrase('Pass')); ?></span>
                                    <?php else: ?>
                                        <span class="text-danger"><?php echo e(get_phrase('Fail')); ?></span>
                                    <?php endif; ?>
                                </p>
                            </div>
                        </div>

                        <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $given_answer =
                                    $question->type == 'true_false'
                                        ? $question->answer
                                        : implode(', ', json_decode($question->answer, true));
                                $user_answers = array_key_exists($question->id, $submits)
                                    ? $submits[$question->id]
                                    : [];
                            ?>

                            <div class="result-question mb-4 <?php if($key > 0): ?>  <?php endif; ?>">
                                <div class="mb-1 d-flex align-items-center gap-3">
                                    <span class="serial"><?php echo e(++$key); ?></span>
                                    <div><?php echo $question->title; ?></div>
                                    <?php if(in_array($question->id, $correct_answers)): ?>
                                        <i class="fi fi-br-check text-success"></i>
                                    <?php elseif(in_array($question->id, $wrong_answers)): ?>
                                        <i class="fi fi-br-cross-small text-danger"></i>
                                    <?php endif; ?>
                                </div>

                                <div class="row <?php echo e($question->type == 'fill_blanks' ? 'px-2' : ''); ?>">
                                    <?php if($question->type == 'mcq'): ?>
                                        <?php $options = json_decode($question->options, true) ?? []; ?>
                                        <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php $val = $user_answers ? array_search($option, $user_answers) : ''; ?>
                                            <div class="col-sm-6">
                                                <input class="form-check-input" type="checkbox"
                                                    value="<?php echo e($option); ?>"
                                                    <?php if(is_numeric($val)): ?> checked <?php endif; ?> disabled>
                                                <label
                                                    class="form-check-label text-capitalize"><?php echo e($option); ?></label>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php elseif($question->type == 'fill_blanks'): ?>
                                        <input type="text" class="form-control tagify" data-role="tagsinput"
                                            value="<?php echo e(json_encode($user_answers)); ?>" disabled>
                                    <?php elseif($question->type == 'true_false'): ?>
                                        <div class="col-sm-2">
                                            <input class="form-check-input" type="radio" disabled
                                                <?php if($user_answers == 'true'): ?> checked <?php endif; ?>>
                                            <label class="form-check-label"><?php echo e(get_phrase('True')); ?></label>
                                        </div>
                                        <div class="col-sm-2">
                                            <input class="form-check-input" type="radio" disabled
                                                <?php if($user_answers == 'false'): ?> checked <?php endif; ?>>
                                            <label class="form-check-label"><?php echo e(get_phrase('False')); ?></label>
                                        </div>
                                    <?php endif; ?>
                                    <p class="text-capitalize text-success fw-600">
                                        <?php echo e(get_phrase('Answer : ')); ?><?php echo e($given_answer); ?>

                                    </p>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>

<script>
    $('.result .tagify:not(.inited)').each(function(index, element) {
        var tagify = new Tagify(element, {
            placeholder: '<?php echo e(get_phrase('Enter your keywords')); ?>'
        });
        $(element).addClass('inited');
    });
</script>
<?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/admin/quiz_result/preview.blade.php ENDPATH**/ ?>