<style>
    .question {
        min-height: auto !important;
    }
</style>

<div class="result">
    <?php
        $submits = $result->submits ? json_decode($result->submits, true) : [];
        $correct_answers = $result->correct_answer ? json_decode($result->correct_answer, true) : [];
        $wrong_answers = $result->wrong_answer ? json_decode($result->wrong_answer, true) : [];
    ?>

    <div class="row mb-3">
        <div class="col-md-6">
            <p><?php echo e(get_phrase('Duration : ')); ?>

                <?php $duration = explode(':', $quiz->duration); ?>
                <?php echo e($duration[0]); ?> <?php echo e(get_phrase('Hour')); ?>

                <?php echo e($duration[1]); ?> <?php echo e(get_phrase('Minute')); ?>

                <?php echo e($duration[1]); ?> <?php echo e(get_phrase('Second')); ?>

            </p>
            <p><?php echo e(get_phrase('Total Mark : ')); ?><?php echo e($quiz->total_mark); ?></p>
            <p><?php echo e(get_phrase('Pass Mark : ')); ?><?php echo e($quiz->pass_mark); ?></p>
        </div>
        <div class="col-md-6">
            <p><?php echo e(get_phrase('Correct Answer : ')); ?><?php echo e(count($correct_answers)); ?></p>
            <p><?php echo e(get_phrase('Wrong Answer : ')); ?><?php echo e(count($wrong_answers)); ?></p>
            <p><?php echo e(get_phrase('Result : ')); ?>

                <?php if(count($correct_answers) >= $quiz->pass_mark): ?>
                    <span class="text-success"><?php echo e(get_phrase('Pass')); ?></span>
                <?php else: ?>
                    <span class="text-danger"><?php echo e(get_phrase('Fail')); ?></span>
                <?php endif; ?>
            </p>								</div>		
			<div class="col-md-12">	
				<?php				
					$error = '';				
					$score = '';				

					$total_questions = count($questions);				
					$correct = count($correct_answers);				
					$wrong = count($wrong_answers);				
					$total_marks = (float) $quiz->total_mark;				
					$passing_marks = (float) $quiz->pass_mark;				

					// Calculate skipped questions
					$attempted = $correct + $wrong;
					$skipped = $total_questions - $attempted;

					if ($attempted > $total_questions) {					
						$error = "Correct + Wrong answers cannot exceed Total Questions.";				
					} else {					
						$marks_per_question = $total_marks / $total_questions;					

						if($quiz->is_minusmarking == 'YES'){
						// Apply penalty: for every 3 wrong answers, 1 extra question is deducted
							$minusmarking = ($quiz->minusmarking == '')?0:$quiz->minusmarking;
							$extra_penalty_questions = floor($wrong / (int) $minusmarking);
						}else{
							$extra_penalty_questions = 0;
						}

						// Total deducted questions (wrong + penalty)
						$deducted_questions = $wrong + $extra_penalty_questions;					
						$deducted_marks = $deducted_questions * $marks_per_question;					

						// Calculate score
						$score = $total_marks - ($deducted_marks + $skipped * $marks_per_question);					
						if ($score < 0) $score = 0;					

						// Result status
						$result_status = ($score >= $passing_marks) ? "PASS" : "FAIL";				
					}										

					// Optional: display info
					/*
					echo "<p>Total Questions: $total_questions</p>";
					echo "<p>Correct Answers: $correct</p>";
					echo "<p>Wrong Answers: $wrong</p>";
					echo "<p>Skipped Questions: $skipped</p>";
					echo "<p>Extra Penalty Questions: $extra_penalty_questions</p>";
					echo "<p>Final Score: $score / $total_marks ($result_status)</p>";
					*/
					?>
			
									
							<div class="result <?php echo ($result_status == 'FAIL') ? 'fail' : ''; ?>">	
							<table class="table table-bordered table-sm">
								<tr>
									<th>Total Questions</th>
									<td><?php echo $total_questions; ?></td>
								</tr>
								<tr>
									<th>Correct Answers</th>
									<td><?php echo $correct; ?></td>
								</tr>
								<tr>
									<th>Wrong Answers</th>
									<td><?php echo $wrong; ?></td>
								</tr>
								<tr>
									<th>Skipped Questions</th>
									<td><?php echo $skipped; ?></td>
								</tr>
								<?php if($quiz->is_minusmarking == 'YES'): ?>
								<tr>
									<th style="width: 50%;">Extra Penalty (for every <?php echo e(($quiz->minusmarking == '')?0:$quiz->minusmarking); ?> wrong)</th>
									<td><?php echo $extra_penalty_questions; ?></td>
								</tr>
								<?php endif; ?>
								<?php if ($error): ?>				
								<tr>
									<th>Error</th>
									<td><?php echo htmlspecialchars($error); ?></td>									
								</tr>			
								<?php elseif ($score): ?>	
								<tr>
									<th>Marks Deducted</th>
									<td><?php echo round($deducted_marks, 2); ?></td>
								</tr>
								<tr>
									<th>Final Score</th>
									<td><?php echo round($score, 2); ?> / <?php echo $total_marks; ?></td>
								</tr>
								<?php endif; ?>		
							</table>

							</div>			
										
        </div>
    </div>

    <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $given_answer =
                $question->type == 'true_false'
                    ? $question->answer
                    : implode(', ', json_decode($question->answer, true));
            $user_answers = array_key_exists($question->id, $submits) ? $submits[$question->id] : [];
        ?>

        <div class="result-question mb-4 <?php if($key > 0): ?>  <?php endif; ?>">
            <div class="mb-1 d-flex align-items-center gap-3">
                <span class="serial"><?php echo e(++$key); ?></span>
                <div><?php echo $question->title; ?></div>

                <?php if(in_array($question->id, $correct_answers)): ?>
                    <i class="fi fi-br-check text-success"></i>
                <?php elseif(in_array($question->id, $wrong_answers)): ?>
                    <i class="fi fi-br-cross-small text-danger"></i>
                <?php endif; ?>
            </div>

            <div class="row gap-0">
                <?php if($question->type == 'mcq'): ?>
                    <?php $options = json_decode($question->options, true) ?? []; ?>
                    <?php $__currentLoopData = $options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php $val = $user_answers ? array_search($option, $user_answers) : ''; ?>
                        <div class="col-sm-6">
                            <input class="form-check-input" type="checkbox" value="<?php echo e($option); ?>"
                                <?php if(is_numeric($val)): ?> checked <?php endif; ?> disabled>
                            <label class="form-check-label text-capitalize"><?php echo e($option); ?></label>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php elseif($question->type == 'fill_blanks'): ?>
                    <input type="text" class="form-control tagify" data-role="tagsinput"
                        value="<?php echo e(json_encode($user_answers)); ?>" disabled>
                <?php elseif($question->type == 'true_false'): ?>
                    <div class="col-sm-2">
                        <input class="form-check-input" type="radio" disabled
                            <?php if($user_answers == 'true'): ?> checked <?php endif; ?>>
                        <label class="form-check-label"><?php echo e(get_phrase('True')); ?></label>
                    </div>
                    <div class="col-sm-2">
                        <input class="form-check-input" type="radio" disabled
                            <?php if($user_answers == 'false'): ?> checked <?php endif; ?>>
                        <label class="form-check-label"><?php echo e(get_phrase('False')); ?></label>
                    </div>
                <?php endif; ?>
                <p class="text-capitalize text-success fw-600">
                    <?php echo e(get_phrase('Answer : ')); ?><?php echo e($given_answer); ?>

                </p>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="row">
        <div class="col-12 d-flex gap-3 justify-content-center">
            <button type="button" class="eBtn gradient border-0 mb-4 d-flex align-items-center gap-2" id="backBtn"
                onclick="back()"><i class="fi fi-rr-angle-small-left fs-5"></i><?php echo e(get_phrase('Back')); ?></button>
        </div>
    </div>
</div>

<script>
    // back to main
    function back() {
        description.classList.remove('d-none');
        starterContainer.classList.remove('d-none');
        document.querySelector('.result').remove();
    }

    $('.result .tagify:not(.inited)').each(function(index, element) {
        var tagify = new Tagify(element, {
            placeholder: '<?php echo e(get_phrase('Enter your keywords')); ?>'
        });
        $(element).addClass('inited');
    });
</script>
<?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/course_player/quiz/result.blade.php ENDPATH**/ ?>