
<?php $__env->startPush('title', get_phrase('Page Builder')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?>
<style>
    .no-disabled:disabled{
        opacity: 1;
    }
</style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('Home Page Builder')); ?>

                </h4>

                <a onclick="showRightModal('<?php echo e(route('view', ['path' => 'admin.page_builder.page_create'])); ?>', '<?php echo e(get_phrase('Create Page')); ?>')" href="#"
                    class="btn ol-btn-outline-secondary d-flex align-items-center cg-10px">
                    <span class="fi-rr-plus"></span>
                    <span><?php echo e(get_phrase('Create Page')); ?></span>
                </a>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="ol-card p-4">
                <div class="ol-card-body">
                    <table class="table eTable table-hover">
                        <thead>
                            <tr>
                                <th scope="col"><?php echo e(get_phrase('#')); ?></th>
                                <th scope="col"><?php echo e(get_phrase('Page Name')); ?></th>
                                <th scope="col"><?php echo e(get_phrase('Status')); ?></th>
                                <th scope="col"><?php echo e(get_phrase('Action')); ?></th>
                            </tr>
                        </thead>

                        <?php $__currentLoopData = App\Models\Builder_page::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(++$key); ?></td>
                                <td><?php echo e($page->name); ?></td>
                                <td>
                                    <div class="eSwitches">
                                        <div class="form-check form-switch">
                                            <input
                                                onchange="actionTo('<?php echo e(route('admin.page.status', ['id' => $page->id])); ?>'); pageSwitcher(this);"
                                                class="form-check-input form-switch-medium no-disabled" name="home_page" type="checkbox" <?php if($page->status == 1): ?> checked disabled <?php endif; ?>>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <?php if($page->is_permanent == 0): ?>
                                        <a href="<?php echo e(route('admin.page.preview', $page->id)); ?>" target="_blank"
                                            class="btn ol-btn-outline-secondary ol-btn-sm"><?php echo e(get_phrase('Preview')); ?></a>
                                        <a href="<?php echo e(route('admin.page.layout.edit', ['id' => $page->id])); ?>"
                                            class="btn ol-btn-outline-secondary ol-btn-sm"><?php echo e(get_phrase('Edit Layout')); ?></a>
                                        <a class="btn ol-btn-outline-secondary ol-btn-sm"
                                            onclick="showRightModal('<?php echo e(route('view', ['path' => 'admin.page_builder.page_edit', 'id' => $page->id])); ?>', '<?php echo e(get_phrase('Edit Page')); ?>')"
                                            href="#" class="btn text-secondary"><?php echo e(get_phrase('Edit')); ?></a>
                                        <a class="btn ol-btn-outline-secondary ol-btn-sm" onclick="confirmModal('<?php echo e(route('admin.page.delete', ['id' => $page->id])); ?>')"
                                            href="#" class="btn text-danger"><?php echo e(get_phrase('Delete')); ?></a>
                                    <?php endif; ?>
                                    <?php if($page->edit_home_id == 1): ?>
                                        <a class="btn ol-btn-outline-secondary ol-btn-sm"
                                            onclick="showRightModal('<?php echo e(route('view', ['path' => 'admin.setting.home_edit.home_edit', 'id' => $page->id])); ?>', '<?php echo e(get_phrase('Edit Home Page')); ?>')"
                                            href="#" class="btn text-secondary"><?php echo e(get_phrase('Edit Home')); ?></a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </table>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        "use strict";

        function pageSwitcher(elem){
            $('.form-switch-medium').not(elem).prop('disabled', false);
            $('.form-switch-medium').not(elem).prop('checked', false);

            setTimeout(() => {
                $(elem).prop('checked', true);
                $(elem).prop('disabled', true);
            }, 200);
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/admin/page_builder/page_list.blade.php ENDPATH**/ ?>