<?php
    $my_id = auth()->user()->id;
    if (isset($search)) {
        $my_threads = App\Models\MessageThread::where(function ($query) use ($my_id) {
            $query->where('contact_one', $my_id)->orWhere('contact_two', $my_id);
        })
            ->where(function ($query) use ($search) {
                $query->whereHas('user', function ($query) use ($search) {
                    $query->where('name', 'like', "%$search%")->orWhere('email', 'like', "%$search%");
                });
            })
            ->orderBy('updated_at', 'desc')->get();
    } else {
        $my_threads = App\Models\MessageThread::where('contact_one', $my_id)->orWhere('contact_two', $my_id)->orderBy('updated_at', 'desc')->get();
    }

?>
<?php $__currentLoopData = $my_threads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $thread): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php
        $last_message = $thread->messages()->orderBy('id', 'desc')->firstOrNew();
        $number_of_unread_message = $thread->messages()->where('read', '!=', 1)->count();
    ?>
    <li>
        <a href="<?php echo e(route('admin.message', ['message_thread' => $thread->code])); ?>" class="message-sidebar-message <?php if($thread_code == $thread->code): ?> active <?php endif; ?>">
            <div class="user">
                <img src="<?php echo e(get_image($thread->user->photo)); ?>" alt="">
            </div>
            <div class="details d-flex justify-content-between">
                <div class="name-message">
                    <h6 class="name"><?php echo e($thread->user->name); ?></h6>
                    <p class="message ellipsis-line-2"><?php echo e(ellipsis($last_message->message, 160)); ?></p>
                </div>
                <?php if($last_message->created_at): ?>
                    <div class="time text-end">
                        <?php if($number_of_unread_message > 0): ?>
                            <span class="badge bg-danger"><?php echo e($number_of_unread_message); ?></span>
                        <?php endif; ?>
                        <p class="mt-2"><?php echo e(timeAgo($last_message->created_at)); ?></p>
                    </div>
                <?php endif; ?>
            </div>
        </a>
    <li>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/admin/message/message_left_side_bar.blade.php ENDPATH**/ ?>