<?php
    $home_page_identifire = App\Models\Builder_page::where('id', $id)->first()->identifier;
?>
<form action="<?php echo e(route('admin.update.home', ['id' => $id])); ?>" method="post" enctype="multipart/form-data">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="type" value="<?php echo e($home_page_identifire); ?>">
    <?php if($home_page_identifire == 'cooking'): ?>
        <h5 class="title mt-4 mb-3"><?php echo e(get_phrase('Become An Instructor')); ?></h5>
        <div class="row">
            <div class="col-md-12">
                <?php
                    $instructor_speech = json_decode(get_homepage_settings('cooking'));
                ?>
                <div id="motivational_speech_area">
                    <div id="blank_motivational_speech_field">
                        <div class="d-flex mt-2 border-top pt-2">
                            <div class="flex-grow-1 px-2 mb-3">
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Title')); ?></label>
                                    <input type="text" class="form-control ol-form-control" name="title" value="<?php echo e($instructor_speech->title ?? ''); ?>" placeholder="Enter a title" required>
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Description')); ?></label>
                                    <textarea name="description" class="form-control ol-form-control" placeholder="<?php echo e(get_phrase('Description')); ?>" required><?php echo e($instructor_speech->description ?? ''); ?></textarea>
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Video Url')); ?></label>
                                    <input type="text" class="form-control ol-form-control" name="video_url" value="<?php echo e($instructor_speech->video_url ?? ''); ?>" placeholder="enter a video url" required>
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Image')); ?></label>
                                    <div class="custom-file">
                                        <input name="previous_image" type="hidden" value="<?php echo e($instructor_speech->image ?? ''); ?>">
                                        <input type="file" class="form-control ol-form-control" name="image" value="<?php echo e($instructor_speech->image ?? ''); ?>" accept="image/*">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="fpb-7 mb-2 flex-grow-1 px-2">
                    <button type="submit" class="btn ol-btn-primary"><?php echo e(get_phrase('Save changes')); ?></button>
                </div>
            </div>
        </div>
    <?php elseif($home_page_identifire == 'university'): ?>
        <div class="row">
            <div class="col-md-12">
                <?php
                    $university = json_decode(get_homepage_settings('university'));
                ?>
                <h5 class="title mt-4 mb-3"><?php echo e(get_phrase('About Us Image')); ?></h5>
                <div id="motivational_speech_area">
                    <div id="blank_motivational_speech_field">
                        <div class="d-flex mt-2 border-top pt-2">
                            <div class="flex-grow-1 px-2 mb-3">
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Image')); ?></label>
                                    <div class="custom-file">
                                        <input name="previous_image" type="hidden" value="<?php echo e($university->image ?? ''); ?>">
                                        <input type="file" class="form-control ol-form-control" name="image" value="<?php echo e($university->image ?? ''); ?>" accept="image/*">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <h5 class="title mt-4 mb-3"><?php echo e(get_phrase('Faq  Image')); ?></h5>
                <div id="motivational_speech_area">
                    <div id="blank_motivational_speech_field">
                        <div class="d-flex mt-2 border-top pt-2">
                            <div class="flex-grow-1 px-2 mb-3">
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Faq Image')); ?></label>
                                    <div class="custom-file">
                                        <input name="previous_faq_image" type="hidden" value="<?php echo e($university->faq_image ?? ''); ?>">
                                        <input type="file" class="form-control ol-form-control" name="faq_image" value="<?php echo e($university->faq_image ?? ''); ?>" accept="image/*">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <h5 class="title mt-4 mb-3"><?php echo e(get_phrase('Slider image & video link')); ?></h5>
                <div class="row">
                    <div class="col-6">
                        <button type="button" onclick="addSliderImageField()" class="btn ol-btn-primary"><i class="fi-rr-plus-small"></i> <?php echo e(get_phrase('Add Image')); ?></button>
                    </div>
                    <div class="col-6">
                        <button type="button" onclick="addSliderVideoField()" class="btn ol-btn-primary"><i class="fi-rr-plus-small"></i> <?php echo e(get_phrase('Add Video Link')); ?></button>
                    </div>
                </div>

                <div id="slider_area">
                    <?php
                        $university = json_decode(get_homepage_settings('university'));
                        $slider_items = json_decode($university->slider_items ?? '{}', true) ?? [];
                    ?>
                    <?php $__currentLoopData = $slider_items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $slider_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if(file_exists(public_path($slider_item))): ?>
                            <div class="d-flex mt-2 border-top pt-2 align-items-center">
                                <img width="50px" src="<?php echo e(asset($slider_item)); ?>" alt="">
                                <div class="flex-grow-1 px-2 mb-3">
                                    <div class="fpb-7 mb-3">
                                        <label class="form-label ol-form-label"><?php echo e(get_phrase('Image')); ?></label>
                                        <div class="custom-file">
                                            <input type="hidden" value="<?php echo e($slider_item); ?>" class="form-control ol-form-control" name="previous_slider_items[]" >
                                            <input type="hidden" value="<?php echo e($slider_item); ?>" class="form-control ol-form-control" name="slider_items[]">
                                            <input type="file" class="form-control ol-form-control" name="slider_items[]" accept="image/*">
                                        </div>
                                    </div>
                                </div>
                                <button class="btn btn-danger" onclick="$(this).parent().remove();"><i class="fi-rr-minus-small"></i></button>
                            </div>
                        <?php else: ?>
                            <div class="d-flex mt-2 border-top pt-2 align-items-center">
                                <div class="flex-grow-1 px-2 mb-3">
                                    <div class="fpb-7 mb-3">
                                        <label class="form-label ol-form-label"><?php echo e(get_phrase('Video Link')); ?> <small>(<?php echo e(get_phrase('Youtube')); ?> & <?php echo e(get_phrase('HTML5')); ?>)</small></label>
                                        <div class="custom-file">
                                            <input type="hidden" value="<?php echo e($slider_item); ?>" class="form-control ol-form-control" name="previous_slider_items[]" >
                                            <input type="text" value="<?php echo e($slider_item); ?>" class="form-control ol-form-control" name="slider_items[]">
                                        </div>
                                    </div>
                                </div>
                                <button class="btn btn-danger" onclick="$(this).parent().remove();"><i class="fi-rr-minus-small"></i></button>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>

                <hr>

                <div class="fpb-7 mb-2 flex-grow-1 mt-3">
                    <button type="submit" class="btn ol-btn-primary"><?php echo e(get_phrase('Save changes')); ?></button>
                </div>
            </div>
        </div>
    <?php elseif($home_page_identifire == 'development'): ?>
        <div class="row">
            <h5 class="title mt-4 mb-3"><?php echo e(get_phrase('About Us')); ?></h5>
            <div class="col-md-12">
                <?php
                    $development = json_decode(get_homepage_settings('development'));
                ?>
                <div id="motivational_speech_area">
                    <div id="blank_motivational_speech_field">
                        <div class="d-flex mt-2 border-top pt-2">
                            <div class="flex-grow-1 px-2 mb-3">
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Title')); ?></label>
                                    <input type="text" class="form-control ol-form-control" name="title" value="<?php echo e($development->title ?? ''); ?>" placeholder="Enter a title" required>
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Description')); ?></label>
                                    <textarea name="description" class="form-control ol-form-control" placeholder="<?php echo e(get_phrase('Description')); ?>" required><?php echo e($development->description ?? ''); ?></textarea>
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Image')); ?></label>
                                    <div class="custom-file">
                                        <input name="previous_image" type="hidden" value="<?php echo e($development->image ?? ''); ?>">
                                        <input type="file" class="form-control ol-form-control" name="image" value="<?php echo e($development->image ?? ''); ?>" accept="image/*">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="fpb-7 mb-2 flex-grow-1 px-2">
                    <button type="submit" class="btn ol-btn-primary"><?php echo e(get_phrase('Save changes')); ?></button>
                </div>
            </div>
        </div>
    <?php elseif($home_page_identifire == 'kindergarden'): ?>
        <div class="row">
            <h5 class="title mt-4 mb-3"><?php echo e(get_phrase('About Us')); ?></h5>
            <div class="col-md-12">
                <?php
                    $kindergarden = json_decode(get_homepage_settings('kindergarden'));
                ?>
                <div id="motivational_speech_area">
                    <div id="blank_motivational_speech_field">
                        <div class="d-flex mt-2 border-top pt-2">
                            <div class="flex-grow-1 px-2 mb-3">
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Title')); ?></label>
                                    <input type="text" class="form-control ol-form-control" name="title" value="<?php echo e($kindergarden->title ?? ''); ?>" placeholder="Enter a title" required>
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Description')); ?></label>
                                    <textarea name="description" class="form-control ol-form-control" placeholder="<?php echo e(get_phrase('Description')); ?>" required><?php echo e($kindergarden->description ?? ''); ?></textarea>
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Image')); ?></label>
                                    <div class="custom-file">
                                        <input name="previous_image" type="hidden" value="<?php echo e($kindergarden->image ?? ''); ?>">
                                        <input type="file" class="form-control ol-form-control" name="image" value="<?php echo e($kindergarden->image ?? ''); ?>" accept="image/*">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="fpb-7 mb-2 flex-grow-1 px-2">
                    <button type="submit" class="btn ol-btn-primary"><?php echo e(get_phrase('Save changes')); ?></button>
                </div>
            </div>
        </div>
    <?php elseif($home_page_identifire == 'marketplace'): ?>
        <h5 class="title mt-4 mb-3"><?php echo e(get_phrase('Become An Instructor')); ?></h5>
        <div class="row">
            <div class="col-md-12">
                <?php
                    $settings = get_homepage_settings('marketplace');
                    $marketplace = json_decode($settings);
                    if ($marketplace && isset($marketplace->instructor)) {
                        $instructor = $marketplace->instructor;
                    }
                ?>
                <div id="motivational_speech_area">
                    <div id="blank_motivational_speech_field">
                        <div class="d-flex mt-2 border-top pt-2">
                            <div class="flex-grow-1 px-2 mb-3">
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Title')); ?></label>
                                    <input type="text" class="form-control ol-form-control" name="title" value="<?php echo e($instructor->title ?? ''); ?>" placeholder="Enter a title" required>
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Description')); ?></label>
                                    <textarea name="description" class="form-control ol-form-control" placeholder="<?php echo e(get_phrase('Description')); ?>" required><?php echo e($instructor->description ?? ''); ?></textarea>
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Video Url')); ?></label>
                                    <input type="text" class="form-control ol-form-control" name="video_url" value="<?php echo e($instructor->video_url ?? ''); ?>" placeholder="enter a video url" required>
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Image')); ?></label>
                                    <div class="custom-file">
                                        <input name="previous_image" type="hidden" value="<?php echo e($instructor->image ?? ''); ?>">
                                        <input type="file" class="form-control ol-form-control" name="image" value="<?php echo e($instructor->image ?? ''); ?>" accept="image/*">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="row">
            <h5 class="title mt-4 mb-3"><?php echo e(get_phrase('Banner Information')); ?></h5>
            <div class="col-md-12">
                <div id = "motivational_speech_areas">
                    <?php
                        $settings = get_homepage_settings('marketplace');
                        if (!$settings) {
                            $settings = '{"slider":[{"banner_title":"","banner_description":""}]}';
                        }
                        $marketplace = json_decode($settings);
                        $sliders = [];
                        $maxKey = 0;
                        if ($marketplace && isset($marketplace->slider)) {
                            $sliders = $marketplace->slider;
                            $maxKey = count($sliders) > 0 ? max(array_keys((array) $sliders)) : 0;
                        }
                    ?>
                    <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="d-flex mt-2">
                            <input type="hidden" name="slider[]" value="<?php echo e($key); ?>">
                            <div class="flex-grow-1 px-2 mb-3">
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Title')); ?></label>
                                    <input type="text" class="form-control ol-form-control" name="banner_title<?php echo e($key); ?>" placeholder="<?php echo e(get_phrase('Title')); ?>" value="<?php echo e($slider?->banner_title); ?>">
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Description')); ?></label>
                                    <textarea name="banner_description<?php echo e($key); ?>" class="form-control ol-form-control" placeholder="<?php echo e(get_phrase('Description')); ?>"><?php echo e($slider?->banner_description); ?></textarea>
                                </div>

                            </div>

                            <?php if($key == 0): ?>
                                <div class="pt-4">
                                    <button type="button" class="btn ol-btn-light ol-icon-btn mt-2" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Add new')); ?>" onclick="appendMotivational_speech()"> <i class="fi-rr-plus-small"></i>
                                    </button>
                                </div>
                            <?php else: ?>
                                <div class="pt-4">
                                    <button type="button" class="btn ol-btn-light ol-icon-btn mt-2" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Remove')); ?>" onclick="removeMotivational_speech(this)">
                                        <i class="fi-rr-minus-small"></i> </button>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div id = "blank_motivational_speech_fields">
                        <div class="d-flex mt-2 border-top pt-2">
                            <div class="flex-grow-1 px-2 mb-3">
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Title')); ?></label>
                                    <input type="text" class="form-control ol-form-control" name="banner_title" placeholder="<?php echo e(get_phrase('Title')); ?>">
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Description')); ?></label>
                                    <textarea name="banner_description" class="form-control ol-form-control" placeholder="<?php echo e(get_phrase('Description')); ?>"></textarea>
                                </div>
                            </div>
                            <div class="pt-4">
                                <button type="button" class="btn ol-btn-light ol-icon-btn mt-2" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Remove')); ?>" onclick="removeMotivational_speech(this)">
                                    <i class="fi-rr-minus-small"></i> </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="fpb-7 mb-2 flex-grow-1 px-2">
            <button type="submit" class="btn ol-btn-primary"><?php echo e(get_phrase('Save changes')); ?></button>
        </div>
        <script type="text/javascript">
            "use strict";

            let blank_motivational_speech = jQuery('#blank_motivational_speech_fields').html();
            let sliderCounter = <?php echo e($maxKey + 1); ?>;
            $(document).ready(function() {
                jQuery('#blank_motivational_speech_fields').hide();
            });

            function appendMotivational_speech() {
                let newMotivationalSpeech = jQuery('#blank_motivational_speech_fields').clone();
                newMotivationalSpeech.find('input[name="banner_title"]').attr('name', 'banner_title' + sliderCounter);
                newMotivationalSpeech.find('textarea[name="banner_description"]').attr('name', 'banner_description' + sliderCounter);
                jQuery('#motivational_speech_areas').append(newMotivationalSpeech.html());
                let newHiddenInput = '<input type="hidden" name="slider[]" value="' + sliderCounter + '">';
                jQuery('#motivational_speech_areas').append(newHiddenInput);
                sliderCounter++;
            }

            function removeMotivational_speech(faqElem) {
                jQuery(faqElem).parent().parent().remove();
                sliderCounter--;
            }
        </script>
    <?php elseif($home_page_identifire == 'meditation'): ?>
        <?php
            $bigImage = json_decode(get_homepage_settings('meditation'));
        ?>
        <div class="row">
            <h5 class="title mt-4 mb-3"><?php echo e(get_phrase('Meditation Big  Image')); ?></h5>
            <div id="speech_area">
                <div id="blank_motivational">
                    <div class="d-flex mt-2 border-top pt-2">
                        <div class="flex-grow-1 px-2 mb-3">
                            <div class="fpb-7 mb-3">
                                <label class="form-label ol-form-label"><?php echo e(get_phrase('Big Image')); ?></label>
                                <div class="custom-file">
                                    <input type="hidden" class="form-control ol-form-control" name="big_previous_image" value="<?php echo e($bigImage->big_image ?? ''); ?>">
                                    <input type="file" class="form-control ol-form-control" name="big_image" value="<?php echo e($bigImage->big_image ?? ''); ?>" accept="image/*">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <h5 class="title mt-4 mb-3"><?php echo e(get_phrase('Meditation Featured')); ?></h5>
            <div class="col-md-12">
                <div id = "area">
                    <?php
                        $settings = get_homepage_settings('meditation');
                        if (!$settings) {
                            $settings = '{"meditation":[{"banner_title":"","banner_description":"", "image":""}]}';
                        }
                        $meditation_text = json_decode($settings);
                        $meditations = [];
                        $maxkey = 0;
                        if ($meditation_text && isset($meditation_text->meditation)) {
                            $meditations = $meditation_text->meditation;
                            $maxkey = count($meditations) > 0 ? max(array_keys((array) $meditations)) : 0;
                        }
                    ?>
                    <?php $__currentLoopData = $meditations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="d-flex mt-2">
                            <input type="hidden" name="meditation[]" value="<?php echo e($key); ?>">
                            <div class="flex-grow-1 px-2 mb-3">
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Title')); ?></label>
                                    <input type="text" class="form-control ol-form-control" name="banner_title<?php echo e($key); ?>" placeholder="<?php echo e(get_phrase('Title')); ?>" value="<?php echo e($slider->banner_title); ?>" required>
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Description')); ?></label>
                                    <textarea name="banner_description<?php echo e($key); ?>" class="form-control ol-form-control" placeholder="<?php echo e(get_phrase('Description')); ?>" required><?php echo e($slider->banner_description); ?></textarea>
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Image')); ?></label>
                                    <div class="custom-file">
                                        <input type="hidden" name="old_image<?php echo e($key); ?>" value="<?php echo e($slider->image ?? ''); ?>">
                                        <input type="file" class="form-control ol-form-control" name="image<?php echo e($key); ?>" value="<?php echo e($slider->image ?? ''); ?>" accept="image/*">
                                    </div>
                                </div>

                            </div>

                            <?php if($key == 0): ?>
                                <div class="pt-4">
                                    <button type="button" class="btn ol-btn-light ol-icon-btn mt-2" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Add new')); ?>" onclick="append_speech()"> <i class="fi-rr-plus-small"></i>
                                    </button>
                                </div>
                            <?php else: ?>
                                <div class="pt-4">
                                    <button type="button" class="btn ol-btn-light ol-icon-btn mt-2" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Remove')); ?>" onclick="remove_speech(this)">
                                        <i class="fi-rr-minus-small"></i> </button>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div id = "blank_fields">
                        <div class="d-flex mt-2 border-top pt-2 w-100">
                            <div class="flex-grow-1 px-2 mb-3">
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Title')); ?></label>
                                    <input type="text" class="form-control ol-form-control" name="banner_title" placeholder="<?php echo e(get_phrase('Title')); ?>">
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Description')); ?></label>
                                    <textarea name="banner_description" class="form-control ol-form-control" placeholder="<?php echo e(get_phrase('Description')); ?>"></textarea>
                                </div>
                                <div class="fpb-7 mb-3">
                                    <label class="form-label ol-form-label"><?php echo e(get_phrase('Image')); ?></label>
                                    <div class="custom-file">
                                        <input type="hidden" class="form-control ol-form-control" name="old_image" value="">
                                        <input type="file" class="form-control ol-form-control" name="image" value="" accept="image/*">
                                    </div>
                                </div>
                            </div>
                            <div class="pt-4">
                                <button type="button" class="btn ol-btn-light ol-icon-btn mt-2" name="button" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Remove')); ?>" onclick="remove_speech(this)">
                                    <i class="fi-rr-minus-small"></i> </button>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
            <div class="fpb-7 mb-2 flex-grow-1 px-2">
                <button type="submit" class="btn ol-btn-primary"><?php echo e(get_phrase('Save changes')); ?></button>
            </div>
        </div>
        <script type="text/javascript">
            "use strict";

            let blank_motivational_speech = jQuery('#blank_fields').html();
            let sliderCounter = <?php echo e($maxkey + 1); ?>;
            $(document).ready(function() {
                jQuery('#blank_fields').hide();
            });

            function append_speech() {
                let newMotivationalSpeech = jQuery('#blank_fields').clone();
                newMotivationalSpeech.find('input[name="banner_title"]').attr('name', 'banner_title' + sliderCounter);
                newMotivationalSpeech.find('input[name="image"]').attr('name', 'image' + sliderCounter);
                newMotivationalSpeech.find('input[name="old_image"]').attr('name', 'old_image' + sliderCounter);
                newMotivationalSpeech.find('textarea[name="banner_description"]').attr('name', 'banner_description' + sliderCounter);
                jQuery('#area').append(newMotivationalSpeech.html());
                let newHiddenInput = '<input type="hidden" name="meditation[]" value="' + sliderCounter + '">';
                jQuery('#area').append(newHiddenInput);
                sliderCounter++;
            }

            function remove_speech(faqElem) {
                jQuery(faqElem).parent().parent().remove();
                sliderCounter--;
            }
        </script>
    <?php else: ?>
    <?php endif; ?>
</form>





<div id="sliderBlankImageField" class="d-none">
    <div class="d-flex mt-2 border-top pt-2 align-items-center">
        <div class="flex-grow-1 px-2 mb-3">
            <div class="fpb-7 mb-3">
                <label class="form-label ol-form-label"><?php echo e(get_phrase('Image')); ?></label>
                <div class="custom-file">
                    <input type="hidden" value="no" class="form-control ol-form-control" name="previous_slider_items[]" >
                    <input type="file" class="form-control ol-form-control" name="slider_items[]"accept="image/*">
                </div>
            </div>
        </div>
        <button class="btn btn-danger" onclick="$(this).parent().remove();"><i class="fi-rr-minus-small"></i></button>
    </div>
</div>

<div id="sliderBlankVideoField" class="d-none">
    <div class="d-flex mt-2 border-top pt-2 align-items-center">
        <div class="flex-grow-1 px-2 mb-3">
            <div class="fpb-7 mb-3">
                <label class="form-label ol-form-label"><?php echo e(get_phrase('Video Link')); ?> <small>(<?php echo e(get_phrase('Youtube')); ?> & <?php echo e(get_phrase('HTML5')); ?>)</small></label>
                <div class="custom-file">
                    <input type="hidden" value="no" class="form-control ol-form-control" name="previous_slider_items[]" >
                    <input type="text" class="form-control ol-form-control" name="slider_items[]">
                </div>
            </div>
        </div>
        <button class="btn btn-danger" onclick="$(this).parent().remove();"><i class="fi-rr-minus-small"></i></button>
    </div>
</div>

<script>
    function addSliderImageField() {
        var sliderBlankImageField = $('#sliderBlankImageField').html();
        $('#slider_area').append(sliderBlankImageField);
    }

    function addSliderVideoField() {
        var sliderBlankVideoField = $('#sliderBlankVideoField').html();
        $('#slider_area').append(sliderBlankVideoField);
    }
</script>
<?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/admin/setting/home_edit/home_edit.blade.php ENDPATH**/ ?>