<input type="hidden" name="course_type" value="general" required>
<input type="hidden" name="instructors[]" value="<?php echo e(auth()->user()->id); ?>" required>


<div class="row mb-3">
    <label for="title" class="form-label ol-form-label col-sm-2 col-form-label"><?php echo e(get_phrase('Course title')); ?><span
            class="text-danger ms-1">*</span></label>
    <div class="col-sm-10">
        <input type="text" name="title" value="<?php echo e($course_details->title); ?>" class="form-control ol-form-control"
            id="title" required>
    </div>
</div>

<div class="row mb-3">
    <label for="short_description"
        class="form-label ol-form-label col-sm-2 col-form-label"><?php echo e(get_phrase('Short description')); ?></label>
    <div class="col-sm-10">
        <textarea name="short_description" rows="3" class="form-control ol-form-control" id="short_description"><?php echo e($course_details->short_description); ?></textarea>
    </div>
</div>

<div class="row mb-3">
    <label for="description"
        class="form-label ol-form-label col-sm-2 col-form-label"><?php echo e(get_phrase('Description')); ?></label>
    <div class="col-sm-10">
        <textarea name="description" rows="5" class="form-control ol-form-control text_editor" id="description"><?php echo removeScripts($course_details->description); ?></textarea>
    </div>
</div>

<div class="row mb-3">
    <label class="form-label ol-form-label col-sm-2 col-form-label"><?php echo e(get_phrase('Category')); ?><span
            class="text-danger ms-1">*</span></label>
    <div class="col-sm-10">
        <select class="ol-select2" name="category_id" data-minimum-results-for-search="Infinity" required>
            <option value=""><?php echo e(get_phrase('Select a category')); ?></option>
            <?php $__currentLoopData = App\Models\Category::where('parent_id', 0)->orderBy('title', 'desc')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($category->id); ?>" <?php if($course_details->category_id == $category->id): ?> selected <?php endif; ?>>
                    <?php echo e($category->title); ?></option>

                <?php $__currentLoopData = $category->childs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($sub_category->id); ?>" <?php if($course_details->category_id == $sub_category->id): ?> selected <?php endif; ?>> --
                        <?php echo e($sub_category->title); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
</div>

<div class="row mb-3">
    <label class="form-label ol-form-label col-sm-2 col-form-label"><?php echo e(get_phrase('Course level')); ?><span
            class="text-danger ms-1">*</span></label>
    <div class="col-sm-10">
        <select class="ol-select2" name="level" required>
            <option value=""><?php echo e(get_phrase('Select your course level')); ?></option>
            <option value="beginner" <?php if($course_details->level == 'beginner'): ?> selected <?php endif; ?>><?php echo e(get_phrase('Beginner')); ?>

            </option>
            <option value="intermediate" <?php if($course_details->level == 'intermediate'): ?> selected <?php endif; ?>>
                <?php echo e(get_phrase('Intermediate')); ?></option>
            <option value="advanced" <?php if($course_details->level == 'advanced'): ?> selected <?php endif; ?>><?php echo e(get_phrase('Advanced')); ?>

            </option>
        </select>
    </div>
</div>

<div class="row mb-3">
    <label class="form-label ol-form-label col-sm-2 col-form-label"><?php echo e(get_phrase('Made in')); ?> <span
            class="text-danger ms-1">*</span></label>
    <div class="col-sm-10">
        <select class="ol-select2" name="language" required>
            <option value=""><?php echo e(get_phrase('Select your course language')); ?></option>
            <?php $__currentLoopData = App\Models\Language::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e(strtolower($language->name)); ?>"  <?php if($course_details->language == strtolower($language->name)): ?> selected <?php endif; ?> class="text-capitalize"><?php echo e($language->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
</div>


<div class="row mb-3 ">
    <label for="course_status" class="form-label ol-form-label col-sm-2 col-form-label"><?php echo e(get_phrase('Create as')); ?> <span
            class="text-danger ms-1">*</span></label>
    <div class="col-sm-10">
        <div class="eRadios">
            <div class="form-check">
                <input type="radio" value="active" name="status" class="form-check-input eRadioSuccess"
                    id="status_active" <?php if($course_details->status == 'active'): ?> checked <?php endif; ?> required>
                <label for="status_active" class="form-check-label"><?php echo e(get_phrase('Active')); ?></label>
            </div>

            <div class="form-check">
                <input type="radio" value="private" name="status" class="form-check-input eRadioPrimary"
                    id="status_private" <?php if($course_details->status == 'private'): ?> checked <?php endif; ?> required>
                <label for="status_private" class="form-check-label"><?php echo e(get_phrase('Private')); ?></label>
            </div>

            <div class="form-check">
                <input type="radio" value="upcoming" name="status" class="form-check-input eRadioInfo"
                    id="status_upcoming" <?php if($course_details->status == 'upcoming'): ?> checked <?php endif; ?> required>
                <label for="status_upcoming" class="form-check-label"><?php echo e(get_phrase('Upcoming')); ?></label>
            </div>

            <div class="form-check">
                <input type="radio" value="pending" name="status" class="form-check-input eRadioDanger"
                    id="status_pending" <?php if($course_details->status == 'pending'): ?> checked <?php endif; ?> required>
                <label for="status_pending" class="form-check-label"><?php echo e(get_phrase('Pending')); ?></label>
            </div>

            <div class="form-check">
                <input type="radio" value="draft" name="status" class="form-check-input eRadioSecondary"
                    id="status_draft" <?php if($course_details->status == 'draft'): ?> checked <?php endif; ?> required>
                <label for="status_draft" class="form-check-label"><?php echo e(get_phrase('Draft')); ?></label>
            </div>

            <div class="form-check">
                <input type="radio" value="inactive" name="status" class="form-check-input eRadioDark"
                    id="status_inactive" <?php if($course_details->status == 'inactive'): ?> checked <?php endif; ?> required>
                <label for="status_inactive" class="form-check-label"><?php echo e(get_phrase('Inactive')); ?></label>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home1/cwmsozbb/public_html/resources/views/admin/course/edit_basic.blade.php ENDPATH**/ ?>