
<?php $__env->startPush('title', get_phrase('Frequently asked questions')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Start Breadcrumb -->
    <section class="py-56" data-background="<?php echo e(asset('assets/frontend/images/breadcrumb.png')); ?>">
        <div class="container">
            <ul class="ul-ol d-flex align-items-center cg-17 pb-20">
                <li class="d-flex align-items-center cg-12">
                    <div class="d-flex">
                        <img src="<?php echo e(asset('assets/frontend/images/icon/home.svg')); ?>" alt="" />
                    </div>
                    <p class="fz-16 fw-500 lh-30 text-white"><?php echo e(get_phrase('Home')); ?></p>
                </li>
                <li class="d-flex align-items-center cg-12">
                    <div class="d-flex">
                        <img src="<?php echo e(asset('assets/frontend/images/icon/arrow-right-white.svg')); ?>" alt="" />
                    </div>
                    <p class="fz-16 fw-500 lh-30 text-white"><?php echo e(get_phrase('FAQ')); ?></p>
                </li>
            </ul>
            <h4 class="fz-56 fw-600 lh-64 text-white"><?php echo e(get_phrase('Frequently asked questions')); ?> </h4>
        </div>
    </section>
    <!-- End Breadcrumb -->

    <!-- Frequently Asked Questions Area Start -->
    <section>
        <div class="container">
            <div class="row mb-5">
                <div class="col-md-12">
                    <h1 class="title mb-4"><?php echo e(get_phrase('Frequently Asked Questions?')); ?></h1>
                    <p class="info">
                        <?php echo e(get_phrase("FAQ provides quick answers to common inquiries, helping users resolve doubts efficiently.")); ?>

                    </p>
                </div>
            </div>
            <div class="row mb-110 mt-5">
                <?php
                    $faqs = json_decode(get_frontend_settings('website_faqs'), true);
                    $faqs = count($faqs) > 0 ? $faqs : [['question' => '', 'answer' => '']];
                ?>
                <div class="col-md-12">
                    <div class="accordion qnaaccordion-two" id="accordionExampleLeft">
                        <?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button <?php echo e($key == 0 ? '' : 'collapsed'); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#collapseLeft<?php echo e($key); ?>" aria-expanded="true" aria-controls="collapseLeft<?php echo e($key); ?>">
                                        <?php echo e($faq['question']); ?>

                                    </button>
                                </h2>
                                <div id="collapseLeft<?php echo e($key); ?>" class="accordion-collapse collapse <?php echo e($key == 0 ? 'show' : ''); ?>" data-bs-parent="#accordionExampleLeft">
                                    <div class="accordion-body">
                                        <p class="answer"><?php echo e($faq['answer']); ?></p>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- Frequently Asked Questions Area End -->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?><?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.default', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home1/cwmsozbb/public_html/resources/views/frontend/default/faq/index.blade.php ENDPATH**/ ?>