<form action="<?php echo e(route('admin.course.quiz.store')); ?>" method="post">
<?php echo csrf_field(); ?>
<input type="hidden" name="course_id" value="<?php echo e($id); ?>">
    <div class="fpb7 mb-3">
        <label class="form-label ol-form-label" for="title">
            <?php echo e(get_phrase('Title')); ?>

            <span class="text-danger ms-1">*</span>
        </label>
        <input class="form-control ol-form-control" type="text" id="title" name="title" required>
    </div>

    <div class="row mb-3">
        <div class="col-sm-12 fpb-7">
            <label class="form-label ol-form-label">
                <?php echo e(get_phrase('Section')); ?>

                <span class="text-danger ms-1">*</span>
            </label>
            <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="section">
                <option value=""><?php echo e(get_phrase('Select an option')); ?></option>
                <?php $__currentLoopData = App\Models\Section::where('course_id', $id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($section->id); ?>"><?php echo e($section->title); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
        </div>
    </div>

    <div class="mb-3">
        <label class="form-label ol-form-label" for="duration">
            <?php echo e(get_phrase('Duration')); ?>

            <span class="text-danger ms-1">*</span>
        </label>
        <div class="row">
            <div class="col-4">
                <input class="form-control ol-form-control" type="number" min="0" max="23" name="hour"
                    placeholder="00 hour">
            </div>
            <div class="col-4">
                <input class="form-control ol-form-control" type="number" min="0" max="59" name="minute"
                    placeholder="00 minute">
            </div>
            <div class="col-4">
                <input class="form-control ol-form-control" type="number" min="0" max="59" name="second"
                    placeholder="00 second">
            </div>
        </div>
    </div>
	
	<div class="form-group mb-2">
		<label class="form-label ol-form-label"><?php echo e(get_phrase('Start Time')); ?> <small>mm/dd/yyy hh:mm</small></label>
		<input type="datetime-local" class="form-control ol-form-control" id="start_time_picker_field" name="start_time">
	</div>

	<div class="form-group mb-2">
		<label class="form-label ol-form-label"><?php echo e(get_phrase('End Time')); ?> <small>mm/dd/yyy hh:mm</small></label>
		<input type="datetime-local" class="form-control ol-form-control" id="end_time_picker_field" name="end_time">
	</div>

    <div class="row mb-3">
        <div class="col-sm-4">
            <label class="form-label ol-form-label" for="total_mark">
                <?php echo e(get_phrase('Total Mark')); ?>

                <span class="text-danger ms-1">*</span>
            </label>
            <input class="form-control ol-form-control" type="number" min="1" id="total_mark" name="total_mark"
                required>
        </div>
        <div class="col-sm-4">
            <label class="form-label ol-form-label" for="pass_mark">
                <?php echo e(get_phrase('Pass Mark')); ?>

                <span class="text-danger ms-1">*</span>
            </label>
            <input class="form-control ol-form-control" type="number" min="1" id="pass_mark" name="pass_mark"
                required>
        </div>						<div class="row mb-3">			<div class="col-sm-12 fpb-7">				<label class="form-label ol-form-label">					<?php echo e(get_phrase('Allow Minus Marking')); ?>					<span class="text-danger ms-1">*</span>				</label>				<select class="form-control ol-form-control ol-select2" data-toggle="select2" name="is_minusmarking">					<option value=""><?php echo e(get_phrase('Select an option')); ?></option>										<option value="YES">Yes</option>					<option value="NO">No</option>									</select>			</div>		</div>				<div class="row mb-3">			<div class="col-sm-12 fpb-7">				<label class="form-label ol-form-label">					<?php echo e(get_phrase('Marks Deduction Per Wrong Answer')); ?>					<span class="text-danger ms-1">*</span>				</label>				<select class="form-control ol-form-control ol-select2" data-toggle="select2" name="minusmarking">					<option value=""><?php echo e(get_phrase('Select an option')); ?></option>										<option value="1">1</option>					<option value="2">2</option>					<option value="3">3</option>					<option value="4">4</option>					<option value="5">5</option>					<option value="6">6</option>					<option value="7">7</option>					<option value="8">8</option>					<option value="9">9</option>					<option value="10">10</option>									</select>			</div>		</div>
        <div class="col-sm-4">
            <label class="form-label ol-form-label" for="retake">
                <?php echo e(get_phrase('Retake')); ?>

                <span class="text-danger ms-1">*</span>
            </label>
            <input class="form-control ol-form-control" type="number" min="1" id="retake" name="retake"
                value="1" required>
        </div>
    </div>

    <div class="fpb-7 mb-3">
        <label for="description"
            class="form-label ol-form-label col-form-label"><?php echo e(get_phrase('Description')); ?></label>
        <textarea name="description" rows="5" class="form-control ol-form-control text_editor"></textarea>
    </div>

    <div class="fpb7">
        <button type="submit" class="btn ol-btn-primary"><?php echo e(get_phrase('Add Quiz')); ?></button>
    </div>
</form>

<?php echo $__env->make('admin.init', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/admin/quiz/create.blade.php ENDPATH**/ ?>