<?php
    $questions = App\Models\Question::where('quiz_id', $id)->orderBy('sort')->get();
?>

<?php if($questions->count() > 0): ?>
    <div class="row">
        <div class="col-12 d-flex gap-3">
            <a href="#"
                onclick="ajaxModal('<?php echo e(route('modal', ['admin.questions.create', 'id' => $id])); ?>', '<?php echo e(get_phrase('Add Question')); ?>', 'modal-lg')"
                class="btn ol-btn-light ol-btn-sm"><?php echo e(get_phrase('Add Question')); ?>

            </a>

            <a href="#"
                onclick="ajaxModal('<?php echo e(route('modal', ['admin.questions.sort', 'id' => $id])); ?>', '<?php echo e(get_phrase('Sort Questions')); ?>')"
                class="btn ol-btn-light ol-btn-sm"><?php echo e(get_phrase('Sort Questions')); ?>

            </a>
        </div>
    </div>

    <ul class="list-group-3 mt-3">
        <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $question): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li>
                <h4 class="title d-flex gap-2">
                    <span><?php echo e(++$key); ?>. </span>
                    <div><?php echo $question->title; ?></div>
                </h4>

                <div class="buttons">
                    <a href="#" data-bs-toggle="tooltip"
                        onclick="ajaxModal('<?php echo e(route('modal', ['admin.questions.edit', 'id' => $question->id])); ?>', '<?php echo e(get_phrase('Edit Question')); ?>', 'modal-lg')"
                        class="edit-delete" aria-label="Edit quiz" data-bs-original-title="Edit quiz">
                        <span class="fi-rr-pencil"></span>
                    </a>

                    <a href="#" data-bs-toggle="tooltip"
                        onclick="confirmModal('<?php echo e(route('admin.course.question.delete', $question->id)); ?>'); event.stopPropagation();"
                        class="edit-delete" aria-label="Delete lesson" data-bs-original-title="Delete lesson">
                        <span class="fi-rr-trash"></span>
                    </a>
                </div>
            </li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php else: ?>
    <div class="row">
        <div class="col-8 offset-2">
            <a onclick="ajaxModal('<?php echo e(route('modal', ['admin.questions.create', 'id' => $id])); ?>', '<?php echo e(get_phrase('Add Question')); ?>', 'modal-lg')"
                href="#" class="add-section-block text-center">
                <p class="sub-title"><i class="fi-rr-add"></i></p>
                <h3 class="title text-15px mt-2 fw-500"><?php echo e(get_phrase('Add Question')); ?></h3>
            </a>
        </div>
    </div>
<?php endif; ?>
<?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/admin/questions/index.blade.php ENDPATH**/ ?>