<div class="row">
    <div class="col-md-12 pb-3">
        <a class="btn ol-btn-primary float-end"
            onclick="ajaxModal('<?php echo e(route('modal', ['view_path' => 'admin.course.create_live_class', 'course_id' => $course_details->id])); ?>', '<?php echo e(get_phrase('Add a new live class')); ?>')"><i
                class="fi-rr-plus"></i> <?php echo e(get_phrase('Schedule a new live class')); ?></a>
    </div>
    <div class="col-md-12">
        <div class="table-responsive overflow-auto">
            <table class="table eTable eTable-2">
                <thead>
                    <th><?php echo e(get_phrase('Instructor')); ?></th>
                    <th><?php echo e(get_phrase('Class topic')); ?></th>
                    <th><?php echo e(get_phrase('Class Schedule')); ?></th>
                    <th><?php echo e(get_phrase('Action')); ?></th>
                </thead>
                <tbody>

                    <?php $__currentLoopData = App\Models\Live_class::where('course_id', $course_details->id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $live_class): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <div class="dAdmin_profile d-flex align-items-center min-w-200px">
                                    <div class="dAdmin_profile_img">
                                        <img class="img-fluid rounded-circle image-45" width="40" height="40" src="<?php echo e(get_image($live_class->user->photo)); ?>" />
                                    </div>
                                    <div class="ms-1">
                                        <h4 class="title fs-14px"><?php echo e($live_class->user->name); ?></h4>
                                        <p class="sub-title2 text-12px"><?php echo e($live_class->user->email); ?></p>
                                    </div>
                                </div>
                            </td>
                            <td class="p-0 pt-3">
                                <p class="title text-12px"><?php echo e($live_class->class_topic); ?></p>
                            </td>
                            <td class="p-0 pt-3">
                                <p class="sub-title text-12px"><?php echo e(date('d M Y - h:i A', strtotime($live_class->class_date_and_time))); ?></p>
                            </td>
                            <td class="p-0 pt-3">
                                <a href="<?php echo e(route('admin.live.class.start', ['id' => $live_class->id])); ?>" class="btn py-0 ps-1 pe-1 text-dark" data-bs-toggle="tooltip"
                                    data-bs-title="<?php echo e(get_phrase('Start live class')); ?>"><i class="fi-rr-video-camera"></i></a>
                                <a href="#" class="btn py-0 px-1 text-dark"
                                    onclick="ajaxModal('<?php echo e(route('modal', ['view_path' => 'admin.course.edit_live_class', 'id' => $live_class->id])); ?>', '<?php echo e(get_phrase('Edit live class')); ?>')"
                                    data-bs-toggle="tooltip" data-bs-title="<?php echo e(get_phrase('Edit')); ?>"><i class="fi-rr-pencil"></i></a>
                                <a href="#" class="btn py-0 px-1 text-danger" onclick="confirmModal('<?php echo e(route('admin.live.class.delete', ['id' => $live_class->id])); ?>')"
                                    data-bs-toggle="tooltip" data-bs-title="<?php echo e(get_phrase('Delete')); ?>"><i class="fi-rr-trash"></i></a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php /**PATH /home/u735268861/domains/palsarh.in/public_html/resources/views/admin/course/live_class.blade.php ENDPATH**/ ?>