<?php
    $sections = DB::table('sections')
        ->where('course_id', $id)
        ->orderBy('sort')
    ->get(); ?>
<div class="row">
    <div class="col-12">
        <div id="section-list" class="list-group d-grid gap-2 border-0 mb-3">
            <?php $__currentLoopData = $sections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="list-group-item rounded-3 py-2 px-2 border-1 draggable-item hover-parent d-flex" id="<?php echo e($section->id); ?>">
                    <?php echo e($section->title); ?> <span class="ms-auto"><i class="fi-rr-apps-sort text-muted ps-2 border-start me-2 mt-1 hover-show cursor-move"></i></span>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <button class="btn ol-btn-primary" onclick="sort('<?php echo e($id); ?>')"><?php echo e(get_phrase('Save Changes')); ?></button>
    </div> <!-- end col -->
</div>

<script>
    'use strict';

    $(function() {
        $("#section-list").sortable({
            axis: "y"
        });
    });

    function sort(id) {
        var containerArray = ['section-list'];
        var itemArray = [];
        var itemJSON;
        let course_id = id;

        
        for (var i = 0; i < containerArray.length; i++) {
            $('#' + containerArray[i]).each(function() {
                $(this).find('.draggable-item').each(function() {
                    itemArray.push(this.id);
                });
            });
        }

        itemJSON = JSON.stringify(itemArray);
        $.ajax({
            url: "<?php echo e(route('admin.section.sort')); ?>",
            type: 'POST',
            data: {
                itemJSON: itemJSON,
                course_id: course_id,
            },
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            success: function(response) {
                location.reload();
            }
        });
    }
</script>
<?php /**PATH /home1/cwmsozbb/public_html/resources/views/admin/course/section_sort.blade.php ENDPATH**/ ?>