
<div class="messenger-area">
    <div class="messenger-header d-flex align-items-center justify-content-between">
        <div class="user-wrap d-flex align-items-center">
            <div class="profile">
                <img src="<?php echo e(get_image($thread_details->user->photo)); ?>" alt="">
            </div>
            <div class="name-status">
                <h6 class="name"><?php echo e($thread_details->user->name); ?></h6>
                <!-- for offline just remove active class  -->
                <span class="text-12px">
                    <?php echo e($thread_details->user->email); ?>

                </span>
            </div>
        </div>
    </div>
    <ul class="messenger-body" id="scrollAbleContent">
        <?php
            $my_data = auth()->user();
        ?>
        <?php $__currentLoopData = $thread_details->messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <?php if($message->sender_id == $my_data->id): ?>
                <li>
                    <div class="single-message recipient-user">
                        <div class="user-wrap mb-3 d-flex align-items-center">
                            <div class="profile">
                                <img src="<?php echo e(get_image($my_data->photo)); ?>" alt="">
                            </div>
                            <div class="name-time d-flex align-items-center flex-wrap">
                                <h6 class="name"><?php echo e($my_data->name); ?></h6>
                                <p class="time"><?php echo e(timeAgo($message->created_at)); ?></p>
                            </div>
                        </div>
                        <p class="message"><?php echo e($message->message); ?></p>
                    </div>
                </li>
            <?php else: ?>
                <li>
                    <div class="single-message ">
                        <div class="user-wrap mb-3 d-flex align-items-center">
                            <div class="profile">
                                <img src="<?php echo e(get_image($thread_details->user->photo)); ?>" alt="">
                            </div>
                            <div class="name-time d-flex align-items-center flex-wrap">
                                <h6 class="name"><?php echo e($thread_details->user->name); ?></h6>
                                <p class="time"><?php echo e(timeAgo($message->created_at)); ?></p>
                            </div>
                        </div>
                        <p class="message"><?php echo e($message->message); ?></p>
                    </div>
                </li>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
    <div class="messenger-footer">
        <form action="<?php echo e(route('admin.message.store')); ?>" method="post" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="sender_id" value="<?php echo e($my_data->id); ?>">
            <input type="hidden" name="receiver_id" value="<?php echo e($thread_details->user->id); ?>">
            <input type="hidden" name="thread_id" value="<?php echo e($thread_details->id); ?>">

            <div class="messenger-footer-inner d-flex align-items-center">
                <input type="text" name="message" class="form-control form-control-message" placeholder="Type your message here...">

                <button type="submit" class="btn ol-btn-primary d-flex align-items-center cg-10px">
                    <span class="fi-rr-rocket"></span>
                    <span><?php echo e(get_phrase('Send')); ?></span>
                </button>
            </div>
        </form>
    </div>
</div>

<script>
    "use strict";

    let divElement = document.getElementById('scrollAbleContent');
    // Scroll to the bottom of the div
    divElement.scrollTop = divElement.scrollHeight;
</script>
<?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/admin/message/message_body.blade.php ENDPATH**/ ?>