
<?php $__env->startPush('title', get_phrase('Payment setting')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <?php
        $System_currencies = App\Models\Currency::get();
    ?>
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-4 px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('Payment Settings')); ?>

                </h4>
            </div>
        </div>
    </div>


    <div class="row">
        <div class="col-md-10">
            <?php
                $payment_gateways = App\Models\Payment_gateway::get();
            ?>
            <div class="ol-card">
                <div class="ol-card-body p-4">
                    <div class="d-flex gap-3 flex-wrap flex-md-nowrap">
                        <div class="ol-sidebar-tab">
                            <div class="nav flex-column nav-pills" id="myv-pills-tab" role="tablist" aria-orientation="vertical">
                                <button class="nav-link <?php if(!isset($_GET['tab'])): ?> active <?php endif; ?>" id="v-pills-currency-tab" data-bs-toggle="pill" data-bs-target="#v-pills-currency" type="button" role="tab" aria-controls="v-pills-currency" aria-selected="true">
                                    <span><?php echo e(get_phrase('Currency Settings')); ?></span>
                                </button>

                                <hr>

                                <?php $__currentLoopData = $payment_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <button class="nav-link <?php if(isset($_GET['tab']) && $_GET['tab'] == $payment_gateway->identifier): ?> active <?php endif; ?>" id="v-pills-<?php echo e($payment_gateway->identifier); ?>-tab" data-bs-toggle="pill" data-bs-target="#v-pills-<?php echo e($payment_gateway->identifier); ?>" type="button" role="tab" aria-controls="v-pills-<?php echo e($payment_gateway->identifier); ?>" aria-selected="true">
                                        <span><?php echo e($payment_gateway->title); ?></span>
                                    </button>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="tab-content w-100" id="myv-pills-tabContent">
                            <div class="tab-pane fade <?php if(!isset($_GET['tab'])): ?> show active <?php endif; ?>" id="v-pills-currency" role="tabpanel" aria-labelledby="v-pills-currency-tab" tabindex="0">
                                <h3 class="title text-14px mb-3"><?php echo e(get_phrase('Currency settings')); ?></h3>

                                <div class="alert alert-primary ol-alert-primary mb-3" role="alert">
                                    <p class="sub-title2 fs-16px">
                                        <span class="title2"><?php echo e(get_phrase('Heads up !!')); ?></span>
                                        <?php echo e(get_phrase('Ensure that the system currency and all active payment gateway currencies are same')); ?>

                                    </p>
                                </div>

                                <div class="ol-card-body">
                                    <form action="<?php echo e(route('admin.payment.settings.update')); ?>" method="post" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <input type="hidden" name="top_part" value="top_part">


                                        <div class="fpb-7 mb-3">
                                            <label class="form-label ol-form-label"><?php echo e(get_phrase('Select currency')); ?></label>
                                            <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="system_currency" required>
                                                <option value=""><?php echo e(get_phrase('Select currency')); ?></option>

                                                <?php $__currentLoopData = $System_currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($row->code); ?>" <?php if(get_settings('system_currency') == $row->code): ?> selected <?php endif; ?>><?php echo e($row->code); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>

                                        <div class="fpb-7 mb-3">
                                            <label class="form-label ol-form-label"><?php echo e(get_phrase('Currency position')); ?></label>
                                            <select class="form-control ol-form-control ol-select2" data-toggle="select2" id = "currency_position" name="currency_position" required>
                                                <option value="left" <?php if(get_settings('currency_position') == 'left'): ?> selected <?php endif; ?>>
                                                    <?php echo e(get_phrase('Left')); ?></option>
                                                <option value="right" <?php if(get_settings('currency_position') == 'right'): ?> selected <?php endif; ?>>
                                                    <?php echo e(get_phrase('Right')); ?></option>
                                                <option value="left-space" <?php if(get_settings('currency_position') == 'left-space'): ?> selected <?php endif; ?>>
                                                    <?php echo e(get_phrase('Left with a space')); ?></option>
                                                <option value="right-space" <?php if(get_settings('currency_position') == 'right-space'): ?> selected <?php endif; ?>>
                                                    <?php echo e(get_phrase('Right with a space')); ?></option>
                                            </select>
                                        </div>

                                        <div class="fpb-7 mb-3">
                                            <button type="submit" class="btn ol-btn-primary mt-3"><?php echo e(get_phrase('Update')); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            <?php $__currentLoopData = $payment_gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment_gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="tab-pane fade <?php if(isset($_GET['tab']) && $_GET['tab'] == $payment_gateway->identifier): ?> show active <?php endif; ?>" id="v-pills-<?php echo e($payment_gateway->identifier); ?>" role="tabpanel" aria-labelledby="v-pills-<?php echo e($payment_gateway->identifier); ?>-tab" tabindex="0">
                                    <h3 class="title text-14px mb-3"><?php echo e($payment_gateway->title); ?> <?php echo e(get_phrase('settings')); ?></h3>
                                    <div class="ol-card-body">
                                        <form action="<?php echo e(route('admin.payment.settings.update')); ?>" method="post" enctype="multipart/form-data">
                                            <?php echo csrf_field(); ?>
                                            <input type="hidden" name="identifier" value="<?php echo e($payment_gateway->identifier); ?>">
            
                                            <?php if($payment_gateway->identifier != 'offline'): ?>
                                                <div class="fpb-7 mb-3">
                                                    <label class="mb-2 text-capitalize"><?php echo e(get_phrase('Active')); ?></label>
                                                    <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="status">
                                                        <option value="0" <?php if($payment_gateway->status == 0): ?> selected <?php endif; ?>>
                                                            <?php echo e(get_phrase('No')); ?></option>
                                                        <option value="1" <?php if($payment_gateway->status == 1): ?> selected <?php endif; ?>>
                                                            <?php echo e(get_phrase('Yes')); ?></option>
                                                    </select>
                                                </div>
            
                                                <div class="fpb-7 mb-3">
                                                    <label class="mb-2 text-capitalize"><?php echo e(get_phrase('Want to keep test mode enabled')); ?>?</label>
                                                    <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="test_mode">
                                                        <option value="0" <?php if($payment_gateway->test_mode == 0): ?> selected <?php endif; ?>>
                                                            <?php echo e(get_phrase('No')); ?></option>
                                                        <option value="1" <?php if($payment_gateway->test_mode == 1): ?> selected <?php endif; ?>>
                                                            <?php echo e(get_phrase('Yes')); ?></option>
                                                    </select>
                                                </div>
            
                                                <div class="fpb-7 mb-3">
                                                    <label class="mb-2 text-capitalize"><?php echo e(get_phrase('Select currency')); ?></label>
                                                    <select class="form-control ol-form-control ol-select2" data-toggle="select2" name="currency" required>
                                                        <option value=""><?php echo e(get_phrase('Select currency')); ?></option>
            
                                                        <?php $__currentLoopData = $System_currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($currency->code); ?>" <?php if($payment_gateway->currency == $currency->code): ?> selected <?php endif; ?>><?php echo e($currency->code); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            
                                                    </select>
                                                </div>
            
            
            
                                                <?php $__currentLoopData = json_decode($payment_gateway['keys'], true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($key == 'theme_color'): ?>
                                                        <label class="mb-2 text-capitalize"><?php echo e(get_phrase(str_replace('_', ' ', $key))); ?></label>
                                                        <input type="color" name="<?php echo e($key); ?>" class="form-control ol-form-control" value="<?php echo e($value); ?>" required />
                                                    <?php else: ?>
                                                        <div class="fpb-7 mb-3">
                                                            <label class="mb-2 text-capitalize"><?php echo e(get_phrase(str_replace('_', ' ', $key))); ?></label>
                                                            <input type="text" name="<?php echo e($key); ?>" class="form-control ol-form-control" value="<?php echo e($value); ?>" required />
                                                        </div>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                                <div class="fpb-7 mb-3 col-md-12">
                                                    <select name="status" id="status" class="form-control ol-form-control ol-select2" data-toggle="select2">
                                                        <option value=""><?php echo e(get_phrase('Choose an option')); ?></option>
                                                        <option value="1" <?php if($payment_gateway->status): ?> selected <?php endif; ?>>
                                                            <?php echo e(get_phrase('Active')); ?></option>
                                                        <option value="0" <?php if(!$payment_gateway->status): ?> selected <?php endif; ?>>
                                                            <?php echo e(get_phrase('Inactive')); ?></option>
                                                    </select>
                                                </div>

                                                <?php $__currentLoopData = json_decode($payment_gateway['keys'], true); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="fpb-7 mb-3">
                                                        <label class="mb-2 text-capitalize"><?php echo e(get_phrase(str_replace('_', ' ', $key))); ?></label>
                                                        <textarea name="<?php echo e($key); ?>" rows="5" class="form-control ol-form-control" required><?php echo e($value); ?></textarea>
                                                    </div>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php endif; ?>
            
                                            <div class="row">
                                                <div class="fpb-7 mb-3 col-md-6">
                                                    <button class="btn btn-block ol-btn-primary" type="submit"><?php echo e(get_phrase('Update')); ?>

                                                        <?php echo e($payment_gateway->title); ?> <?php echo e(get_phrase('setting')); ?></button>
                                                </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/admin/setting/payment_setting.blade.php ENDPATH**/ ?>