<?php
    $user = App\Models\User::where('id', $id)->first();
?>
<?php if($user): ?>
    <div class="d-flex flex-column align-items-center justify-content-center h-100 py-4 gap-5">
        <div class="preview-image">
            <img src="<?php echo e(get_image($user->photo)); ?>" alt="user-photo">
        </div>

        <form action="<?php echo e(route('update.profile.picture')); ?>" method="post" enctype="multipart/form-data"><?php echo csrf_field(); ?>
            <div class="form-group d-flex gap-4">
                <input type="file" class="form-control" name="photo" id="profile-photo">
                <button type="submit" class="eBtn gradient border-none"><?php echo e(get_phrase('Upload')); ?></button>
            </div>
        </form>
    </div>
<?php else: ?>
    <p class="py-4"><?php echo e(get_phrase('Data not found.')); ?></p>
<?php endif; ?>

<script src="<?php echo e(asset('assets/frontend/default/js/jquery-3.7.1.min.js')); ?>"></script>
<script>
    "use strict";
    $(document).ready(function() {
        $('#profile-photo').change(function(e) {
            e.preventDefault();

            var path = URL.createObjectURL(event.target.files[0]);
            $('.preview-image img').attr('src', path);
        });
    });
</script>
<?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/frontend/default/upload_profile_pic.blade.php ENDPATH**/ ?>