<?php
    $live_class = App\Models\Live_class::where('id', $id)->first();
?>
<form class="required-form" action="<?php echo e(route('admin.live.class.update', ['id' => $id])); ?>" method="post">
    <?php echo csrf_field(); ?>
    <div class="fpb-7 mb-3">
        <label class="form-label ol-form-label" for="class_topic"><?php echo e(get_phrase('Class Topic')); ?><span class="required">*</span></label>
        <input type="text" value="<?php echo e($live_class->class_topic); ?>" name = "class_topic" id = "class_topic" class="form-control ol-form-control" required>
    </div>

    <div class="fpb-7 mb-3">
        <label class="form-label ol-form-label" for="live_class_instructor_id"><?php echo e(get_phrase('Instructor')); ?><span class="required">*</span></label>
        <select class="ol-select2" name="user_id" id="live_class_instructor_id">
            <?php $__currentLoopData = App\Models\Course::where('id', $live_class->course_id)->first()->instructors(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $instructor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($instructor->id); ?>" <?php if($live_class->user_id == $instructor->id): ?> selected <?php endif; ?>><?php echo e($instructor->name); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <div class="fpb-7 mb-3">
        <label class="form-label ol-form-label" for="class_date_and_time"><?php echo e(get_phrase('Class date and time')); ?><span class="required">*</span></label>
        <input value="<?php echo e(date('Y-m-d\TH:i', strtotime($live_class->class_date_and_time))); ?>" type="datetime-local" class="form-control ol-form-control" name="class_date_and_time" id="class_date_and_time" required>
    </div>

    <div class="fpb-7 mb-3">
        <label class="form-label ol-form-label" for="note_for_student"><?php echo e(get_phrase('Note for your student')); ?></label>
        <textarea class="form-control ol-form-control" name="note" id="note_for_student" rows="4"><?php echo e($live_class->note); ?></textarea>
    </div>

    <div class="fpb-7 mb-3">
        <button type="submit" class="ol-btn-primary"><?php echo e(get_phrase('Update')); ?></button>
    </div>
</form>

<?php echo $__env->make('admin.init', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home1/cwmsozbb/public_html/resources/views/admin/course/edit_live_class.blade.php ENDPATH**/ ?>