

<?php $__env->startPush('title', get_phrase('Categories')); ?>

<?php $__env->startPush('meta'); ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('css'); ?>
<?php $__env->stopPush(); ?>



<?php $__env->startSection('content'); ?>
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('All Category')); ?> <span class="text-muted">(<?php echo e($categories->count()); ?>)</span>
                </h4>

                <a onclick="ajaxModal('<?php echo e(route('modal', ['admin.category.create', 'parent_id' => 0])); ?>', '<?php echo e(get_phrase('Add new category')); ?>')" href="#" class="btn ol-btn-outline-secondary d-flex align-items-center cg-10px">
                    <span class="fi-rr-plus"></span>
                    <span><?php echo e(get_phrase('Add new category')); ?></span>
                </a>
            </div>
        </div>
    </div>


    <div class="row g-4 all-category-list">
        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-6 col-lg-4 col-xl-3">
                <div class="ol-card category-card radious-10px h-100">
                    <img src="<?php echo e(get_image($category->thumbnail)); ?>" class="card-img-top" alt="...">
                    <h6 class="title fs-14px mb-12px px-3 pt-3 d-flex align-baseline">
                        <i class="me-1 <?php echo e($category->icon); ?>"></i>
                        <?php echo e($category->title); ?> <span class="text-muted d-inline-block ms-auto">(<?php echo e($category->childs->count()); ?>)</span>
                    </h6>
                    <div class="ol-card-body">
                        <ul class="list-group list-group-flush">
                            <?php $__currentLoopData = $category->childs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $child_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="list-group-item text-muted">
                                    <div class="row">
                                        <div class="col-auto">
                                            <i class="<?php echo e($child_category->icon); ?>"></i> <span class="text-12px"><?php echo e($child_category->title); ?></span>
                                        </div>
                                        <div class="col-auto ms-auto d-flex subcategory-actions">
                                            <a onclick="ajaxModal('<?php echo e(route('modal', ['admin.category.edit', 'id' => $child_category->id])); ?>', '<?php echo e(get_phrase('Edit category')); ?>')" class="mx-1" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Edit')); ?>" href="#"><i class="fi fi-rr-pen-clip"></i></a>
                                            <a onclick="confirmModal('<?php echo e(route('admin.category.delete', $child_category->id)); ?>')" class="mx-1" data-bs-toggle="tooltip" title="<?php echo e(get_phrase('Delete')); ?>" href="#"><i class="fi fi-rr-trash"></i></a>
                                        </div>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                    <div class="category-footer ol-card-body text-center py-1">
                        <a onclick="ajaxModal('<?php echo e(route('modal', ['admin.category.create', 'parent_id' => $category->id])); ?>', '<?php echo e(get_phrase('Add new category')); ?>')" href="#" class="btn text-12px fw-600"><i class="fi fi-rr-plus"></i></i> <?php echo e(get_phrase('Add')); ?></a>
                        <a href="#" onclick="ajaxModal('<?php echo e(route('modal', ['admin.category.edit', 'id' => $category->id])); ?>', '<?php echo e(get_phrase('Edit category')); ?>')" class="btn text-12px fw-600"><i class="fi fi-rr-pen-clip"></i> <?php echo e(get_phrase('Edit')); ?></a>
                        <a href="#" onclick="confirmModal('<?php echo e(route('admin.category.delete', $category->id)); ?>')" class="btn text-12px fw-600"><i class="fi-rr-trash"></i>
                            <?php echo e(get_phrase('Delete')); ?></a>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home1/cwmsozbb/public_html/resources/views/admin/category/index.blade.php ENDPATH**/ ?>