
<?php $__env->startPush('title', get_phrase('Log In')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?>
    <style>
        .form-icons .right {
            right: 20px;
            cursor: pointer !important;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <?php if(get_frontend_settings('theme') == 'default'): ?>
        <!------------------- Login Area Start  ------>
        <section class="login-area">
            <div class="container">
                <div class="row">
                    <div class="col-lg-7 col-md-6">
                        <div class="login-img">
                            <img src="<?php echo e(asset('assets/frontend/default/image/login.gif')); ?>" alt="...">
                        </div>
                    </div>
                    <div class="col-lg-5 col-md-6">
                        <form action="<?php echo e(route('login')); ?>" class="global-form login-form mt-25" method="POST">
                            <?php echo csrf_field(); ?>
                            <h4 class="g-title"><?php echo e(get_phrase('Login')); ?></h4>
                            <p class="description"><?php echo e(get_phrase('See your growth and get consulting support!')); ?> </p>
                            <div class="form-group">
                                <label for="email" class="form-label"><?php echo e(get_phrase('Email')); ?></label>
                                <input type="email" id="email" name="email" class="form-control" placeholder="<?php echo e(get_phrase('Your Email')); ?>">
                            </div>
                            <div class="form-group">
                                <label for="" class="form-label"><?php echo e(get_phrase('Password')); ?></label>
                                <input type="password" id="password" name="password" class="form-control" placeholder="*********">
                            </div>
                            <div class="form-group mb-25 d-flex justify-content-between align-items-center remember-me">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckChecked" checked>
                                    <label class="form-check-label" for="flexCheckChecked"><?php echo e(get_phrase('Remember Me')); ?></label>
                                </div>
                                <a href="<?php echo e(route('password.request')); ?>"><?php echo e(get_phrase('Forget Password?')); ?></a>
                            </div>
                            <button type="submit" class="eBtn gradient w-100"><?php echo e(get_phrase('Login')); ?></button>
                            <p class="mt-20"><?php echo e(get_phrase("Haven't registered yet?")); ?>

                                <a href="<?php echo e(route('register.form')); ?>"><?php echo e(get_phrase('Register Now')); ?></a>
                            </p>

                            
                        </form>
                    </div>
                </div>
            </div>
        </section>
        <!------------------- Login Area End  ------>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>

    <script>
        "use strict";

        $(document).ready(function() {
            $('.custom-btn').on('click', function(e) {
                e.preventDefault();

                var role = $(this).attr('id');
                if (role == 'admin') {
                    $('#email').val('admin@example.com');
                    $('#password').val('12345678');
                } else if (role == 'student') {
                    $('#email').val('student@example.com');
                    $('#password').val('12345678');
                } else {
                    $('#email').val('instructor@example.com');
                    $('#password').val('12345678');
                }
                $('#login').trigger('click');
            });
        });

        $(document).ready(function() {
            $('#showpassword').on('click', function(e) {
                e.preventDefault();
                const type = $('#password').attr('type');

                if (type == 'password') {
                    $('#password').attr('type', 'text');
                } else {
                    $('#password').attr('type', 'password');
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts' . '.' . get_frontend_settings('theme'), array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/auth/login.blade.php ENDPATH**/ ?>