
<?php $__env->startPush('title', get_phrase('Live class settings')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <!-- Mani section header and breadcrumb -->
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-4 px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <?php echo e(get_phrase('Live Class Settings')); ?>

                </h4>
            </div>
        </div>
    </div>


    <div class="row">
        <div class="col-md-7">
            <div class="ol-card p-4">
                <h3 class="title text-14px mb-3"><?php echo e(get_phrase('Configure ZOOM server-to-server-oauth credentials')); ?></h3>
                <div class="ol-card-body">
                    <form class="required-form" action="<?php echo e(route('admin.live.class.settings.update')); ?>" method="post">
                        <?php echo csrf_field(); ?>

                        <div class="fpb-7 mb-3">
                            <label class="form-label ol-form-label" for="zoom_account_email"><?php echo e(get_phrase('Account Email')); ?><span class="required">*</span></label>
                            <input type="email" name = "zoom_account_email" id = "zoom_account_email" class="form-control ol-form-control" value="<?php echo e(get_settings('zoom_account_email')); ?>" required>
                        </div>

                        <div class="fpb-7 mb-3">
                            <label class="form-label ol-form-label" for="zoom_account_id"><?php echo e(get_phrase('Account ID')); ?><span class="required">*</span></label>
                            <input type="text" name = "zoom_account_id" id = "zoom_account_id" class="form-control ol-form-control" value="<?php echo e(get_settings('zoom_account_id')); ?>" required>
                        </div>

                        <div class="fpb-7 mb-3">
                            <label class="form-label ol-form-label" for="zoom_client_id"><?php echo e(get_phrase('Client ID')); ?><span class="required">*</span></label>
                            <input type="text" name = "zoom_client_id" id = "zoom_client_id" class="form-control ol-form-control" value="<?php echo e(get_settings('zoom_client_id')); ?>" required>
                        </div>

                        <div class="fpb-7 mb-3">
                            <label class="form-label ol-form-label" for="zoom_client_secret"><?php echo e(get_phrase('Client Secret')); ?><span class="required">*</span></label>
                            <input type="text" name = "zoom_client_secret" id = "zoom_client_secret" class="form-control ol-form-control" value="<?php echo e(get_settings('zoom_client_secret')); ?>" required>
                        </div>

                        <hr>

                        <div class="fpb-7 mb-3">
                            <label class="form-label ol-form-label" for="zoom_web_sdk_active"><?php echo e(get_phrase('Do you want to use Web SDK for your live class?')); ?><span class="required">*</span></label><br>
                            <input type="radio" id="zoom_web_sdk_active" class="form-check-input" value="active" name="zoom_web_sdk" <?php if(get_settings('zoom_web_sdk') == 'active'): ?> checked <?php endif; ?>>
                            <label for="zoom_web_sdk_active" onclick="$('.web-ddk-credentials').show()"><?php echo e(get_phrase('Yes')); ?></label>
                            &nbsp;&nbsp;
                            <input type="radio" id="zoom_web_sdk_inactive" class="form-check-input" value="inactive" name="zoom_web_sdk" <?php if(get_settings('zoom_web_sdk') == 'inactive'): ?> checked <?php endif; ?>>
                            <label for="zoom_web_sdk_inactive" onclick="$('.web-ddk-credentials').hide()"><?php echo e(get_phrase('No')); ?></label>
                        </div>

                        <div class="web-ddk-credentials <?php if(get_settings('zoom_web_sdk') == 'inactive'): ?> d-hidden <?php endif; ?>">

                            <div class="fpb-7 mb-3" id="zoom_sdk_client_id">
                                <label class="form-label ol-form-label" for="zoom_sdk_client_id"><?php echo e(get_phrase('Meeting SDK Client ID')); ?><span class="required">*</span></label>
                                <input type="text" name = "zoom_sdk_client_id" id = "zoom_sdk_client_id" class="form-control ol-form-control" value="<?php echo e(get_settings('zoom_sdk_client_id')); ?>" required>
                            </div>

                            <div class="fpb-7 mb-3" id="zoom_web_sdk_client_secret">
                                <label class="form-label ol-form-label" for="zoom_sdk_client_secret"><?php echo e(get_phrase('Meeting SDK Client Secret')); ?><span class="required">*</span></label>
                                <input type="text" name = "zoom_sdk_client_secret" id = "zoom_sdk_client_secret" class="form-control ol-form-control" value="<?php echo e(get_settings('zoom_sdk_client_secret')); ?>" required>
                            </div>
                        </div>

                        <div class="fpb-7 mb-3">
                            <button type="submit" class="btn ol-btn-primary"><?php echo e(get_phrase('Save changes')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/admin/setting/live_class_settings.blade.php ENDPATH**/ ?>