
<?php $__env->startPush('title', get_phrase('Edit course')); ?>

<?php $__env->startSection('content'); ?>
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px d-flex align-items-center">
                    <span class="edit-badge py-2 px-3">
                        <?php echo e(get_phrase('Editing')); ?>

                    </span>
                    <span class="d-inline-block ms-3">
                        <?php echo e($course_details->title); ?>

                    </span>
                </h4>
                <a href="<?php echo e(route('admin.courses')); ?>" class="btn ol-btn-outline-secondary d-flex align-items-center cg-10px ms-auto">
                    <span class="fi-rr-arrow-left"></span>
                    <span><?php echo e(get_phrase('Back')); ?></span>
                </a>
                <a href="https://creativeitem.com/docs" class="btn ol-btn-outline-secondary d-flex align-items-center cg-10px" target="_blank">
                    <span class="fi-rr-arrow-up-right-from-square"></span>
                    <span><?php echo e(get_phrase('Help')); ?></span>
                </a>
            </div>
        </div>
    </div>

    <div class="col-md-12">
        <form class="ajaxForm" action="<?php echo e(route('admin.course.update', $course_details->id)); ?>" method="post" enctype="multipart/form-data"><?php echo csrf_field(); ?>
            <div class="ol-card">
                <div class="ol-card-body p-20px mb-3">

                    <div class="row mb-3">
                        <div class="col-sm-8">
                            <a href="<?php echo e(route('course.details', $course_details->slug)); ?>" target="_blank" class="btn ol-btn-outline-secondary me-3">
                                <?php echo e(get_phrase('Frontend View')); ?>

                                <i class="fi-rr-arrow-up-right-from-square"></i>
                            </a>

                            <?php
                                $watch_history = App\Models\Watch_history::where('course_id', $course_details->course_id)
                                    ->where('student_id', auth()->user()->id)
                                    ->first();

                                $lesson = App\Models\Lesson::where('course_id', $course_details->course_id)
                                    ->orderBy('sort', 'asc')
                                    ->first();

                                if (!$watch_history && $lesson) {
                                    $url['slug'] = $course_details->slug;
                                    $lesson_id = '';
                                } else {
                                    if ($watch_history) {
                                        $lesson_id = $watch_history->watching_lesson_id;
                                    } elseif ($lesson) {
                                        $lesson_id = $lesson->id;
                                    }else{
                                        $lesson_id = '';
                                    }
                                    $url['id'] = $lesson_id;
                                }
                            ?>

                            <a href="<?php echo e(route('course.player', ['slug' => $course_details->slug, 'id' => $lesson_id ?? ''])); ?>" target="_blank" class="btn ol-btn-outline-secondary">
                                <?php echo e(get_phrase('Course Player')); ?>

                                <i class="fi-rr-arrow-up-right-from-square"></i>
                            </a>
                        </div>
                        <div class="col-sm-4 mt-3 mt-sm-0 d-flex justify-content-start justify-content-sm-end">
                            <button type="submit" class="btn ol-btn-outline-secondary <?php if(request('tab') == 'live-class' || request('tab') == 'curriculum'): ?> opacity-0 <?php endif; ?>">
                                <?php echo e(get_phrase('Save Changes')); ?>

                            </button>
                        </div>
                    </div>

                    <div class="d-flex gap-3 flex-wrap flex-md-nowrap">
                        <div class="ol-sidebar-tab">
                            <div class="d-flex flex-column">
                                <?php
                                    $param = request()->route()->parameter('id');
                                    $tab = request('tab');
                                ?>

                                <input type="hidden" name="tab" value="<?php echo e($tab); ?>">

                                <a class="nav-link <?php if($tab == 'curriculum' || $tab == ''): ?> active <?php endif; ?>" href="<?php echo e(route('admin.course.edit', [$param, 'tab' => 'curriculum'])); ?>">
                                    <span class="fi-rr-edit"></span>
                                    <span><?php echo e(get_phrase('Curriculum')); ?></span>
                                </a>

                                <a class="nav-link <?php if($tab == 'basic'): ?> active <?php endif; ?>" href="<?php echo e(route('admin.course.edit', [$param, 'tab' => 'basic'])); ?>">
                                    <span class="icon fi-rr-duplicate"></span>
                                    <span><?php echo e(get_phrase('Basic')); ?></span>
                                </a>

                                <a class="nav-link <?php if($tab == 'live-class'): ?> active <?php endif; ?>" href="<?php echo e(route('admin.course.edit', [$param, 'tab' => 'live-class'])); ?>">
                                    <span class="fi-rr-file-video"></span>
                                    <span><?php echo e(get_phrase('Live Class')); ?></span>
                                </a>

                                <a class="nav-link <?php if($tab == 'pricing'): ?> active <?php endif; ?>" href="<?php echo e(route('admin.course.edit', [$param, 'tab' => 'pricing'])); ?>">
                                    <span class="fi-rr-comment-dollar"></span>
                                    <span><?php echo e(get_phrase('Pricing')); ?></span>
                                </a>

                                <a class="nav-link <?php if($tab == 'info'): ?> active <?php endif; ?>" href="<?php echo e(route('admin.course.edit', [$param, 'tab' => 'info'])); ?>">
                                    <span class="fi-rr-tags"></span>
                                    <span><?php echo e(get_phrase('Info')); ?></span>
                                </a>

                                <a class="nav-link <?php if($tab == 'media'): ?> active <?php endif; ?>" href="<?php echo e(route('admin.course.edit', [$param, 'tab' => 'media'])); ?>">
                                    <span class="fi fi-rr-gallery"></span>
                                    <span><?php echo e(get_phrase('Media')); ?></span>
                                </a>

                                <a class="nav-link <?php if($tab == 'seo'): ?> active <?php endif; ?>" href="<?php echo e(route('admin.course.edit', [$param, 'tab' => 'seo'])); ?>">
                                    <span class="fi-rr-note-medical"></span>
                                    <span><?php echo e(get_phrase('SEO')); ?></span>
                                </a>
                            </div>
                        </div>
                        <div class="tab-content w-100">
                            <?php echo $__env->renderWhen($tab == 'curriculum' || $tab == '', 'admin.course.curriculum', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
                            <?php echo $__env->renderWhen($tab == 'basic', 'admin.course.edit_basic', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
                            <?php echo $__env->renderWhen($tab == 'live-class', 'admin.course.live_class', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
                            <?php echo $__env->renderWhen($tab == 'pricing', 'admin.course.edit_pricing', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
                            <?php echo $__env->renderWhen($tab == 'info', 'admin.course.edit_info', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
                            <?php echo $__env->renderWhen($tab == 'media', 'admin.course.edit_media', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
                            <?php echo $__env->renderWhen($tab == 'seo', 'admin.course.edit_seo', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1])); ?>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/admin/course/edit.blade.php ENDPATH**/ ?>