<div class="sidebar blog-sidebar" action="#">
    <form class="mb-4" action="<?php echo e(route('blogs')); ?>" method="get">
        <div class="widget">
            <div class="search">
                <input type="text" class="form-control" name="search" placeholder="<?php echo e(get_phrase('Search...')); ?>" <?php if(request()->has('search')): ?> value="<?php echo e(request()->input('search')); ?>" <?php endif; ?>>
                <button type="submit" class="submit"><i class="fa-solid fa-magnifying-glass"></i></button>
            </div>
        </div>
    </form>


    <div class="widget border-bottom">
        <h4 class="widget-title pb-15 border-none"><?php echo e(get_phrase('Categories')); ?></h4>
        <ul class="entry-widget" id="blog-category">
            <?php
                $active_category = request()->route()->parameter('category');
                $route_queries = request()->query();
            ?>
            <?php $__currentLoopData = App\Models\BlogCategory::latest()->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $route_queries['category'] = $category->slug; ?>
                <li class="category <?php if($category->slug == $active_category): ?> active <?php endif; ?>" id="<?php echo e($category->slug); ?>">
                    <a href="<?php echo e(route('blogs', $route_queries)); ?>" class="d-flex align-items-center justify-content-between">
                        <span><?php echo e($category->title); ?></span>
                        <span><?php echo e(count_blogs_by_category($category->id)); ?></span>
                    </a>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
        <div class="down-text mb-30 mt-4" id="see-more">
            <?php echo e(get_phrase('Show More')); ?> <i class="fi-rr-plus-small"></i>
        </div>
    </div>
    <div class="widget border-bottom">
        <h4 class="widget-title pb-15 border-none"><?php echo e(get_phrase('Popular Post')); ?></h4>
        <ul class="entry-widget blog-widget blog-widget-post">
            <?php $__currentLoopData = App\Models\Blog::where('status', 1)->latest()->take(4)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="d-flex mb-20">
                    <a href="<?php echo e(route('blog.details', $blog->slug)); ?>">
                        <div class="widget-post-bx">
                            <div class="widget-posts popular-blogs">
                                <div class="ttr-post-media"> <img src="<?php echo e(get_image($blog->thumbnail)); ?>" alt="blog-thumbnail">
                                </div>
                                <div class="ttr-post-info">
                                    <div class="ttr-post-header">
                                        <span><?php echo e(date('d M, Y', strtotime($blog->created_at))); ?></span>
                                        <h6 class="post-titles ellipsis-2"><?php echo e(ucfirst($blog->title)); ?></h6>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
    <div class="widget">
        <h4 class="widget-title pb-15 border-none"><?php echo e(get_phrase('Tags')); ?></h4>
        <ul class="tags overlay-content mt-0">
            <?php $__currentLoopData = get_blog_tags(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><a class="<?php if(isset($_GET['tag']) && $_GET['tag'] == $tag): ?> active <?php endif; ?>" href="<?php echo e(route('blogs', ['tag' => $tag])); ?>"><?php echo e(ucfirst($tag)); ?></a></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
</div>

<?php $__env->startPush('js'); ?>
    <script>
        "use strict";
        $(document).ready(function() {
            $('#see-more').on('click', function(e) {
                e.preventDefault();
                $(this).toggleClass('active');
                let show_more = $(this).html();

                if ($(this).hasClass('active')) {
                    $('#blog-category').css('height', 'auto');
                    $('#blog-category').css('max-height', 'max-content');
                    $(this).css('margin-top', '20px');
                    $(this).html('Show Less <i class="fi-rr-minus-small"></i>');
                } else {
                    $('#blog-category').css('height', 'auto');
                    $('#blog-category').css('max-height', '400px');
                    $(this).css('margin-top', '0px');
                    $(this).html('Show More <i class="fi-rr-plus-small"></i>');
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home1/cwmsozbb/public_html/resources/views/frontend/default/blog/filter.blade.php ENDPATH**/ ?>