
<?php $__env->startPush('title', get_phrase('Wishlist')); ?>
<?php $__env->startPush('meta'); ?><?php $__env->stopPush(); ?>
<?php $__env->startPush('css'); ?><?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <section class="wishlist-content">
        <div class="profile-banner-area"></div>
        <div class="container profile-banner-area-container">
            <div class="row">
                <?php echo $__env->make('frontend.default.student.left_sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>



                <div class="col-lg-9">
                    <h4 class="g-title"><?php echo e(get_phrase('Wishlisted courses')); ?></h4>
                    <div class="row mt-5">
                        <?php $__currentLoopData = $wishlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wishitem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-lg-4 col-md-4 col-sm-6 mb-30">
                                <a href="<?php echo e(route('course.details', $wishitem->slug)); ?>" class="">
                                    <div class="card Ecard g-card wish-card">
                                        <div class="card-head">
                                            <img src="<?php echo e(get_image($wishitem->course_thumbnail)); ?>" alt="<?php echo e(get_phrase('course_thumbnail')); ?>">
                                        </div>
                                        <div class="card-body entry-details">
                                            <div class="info-card">
                                                <div class="creator">
                                                    <!--<img src="<?php echo e(get_image($wishitem->user_photo)); ?>" alt="<?php echo e(get_phrase('user_photo')); ?>">-->
                                                    <h5 class="text-capitalize"><?php echo e($wishitem->level); ?> Level</h5>
                                                </div>
                                                <span data-bs-toggle="tooltip" data-bs-title="<?php echo e(get_phrase('Remove from wishlist')); ?>" class="heart fill-heart toggleWishItem" id="item-<?php echo e($wishitem->course_id); ?>"><i class="fa-solid fa-heart"></i></span>
                                            </div>
                                            <div class="entry-title">
                                                <h3 class="w-100 ellipsis-line-2"><?php echo e($wishitem->title); ?></h3>
                                            </div>
                                            <div class="ct-text">
                                                <h4>
                                                    <?php if($wishitem->is_paid == 0): ?>
                                                        <?php echo e(get_phrase('Free')); ?>

                                                    <?php else: ?>
                                                        <?php if($wishitem->discount_flag == 1): ?>
                                                            <?php $discounted_price = number_format(($wishitem->discounted_price), 2) ?>
                                                            <?php echo e(currency($discounted_price)); ?>

                                                        <?php else: ?>
                                                            <?php echo e(currency(number_format($wishitem->price, 2))); ?>

                                                        <?php endif; ?>
                                                    <?php endif; ?>
                                                </h4>
                                                <p><span>4.8</span><i class="fa fa-star"></i></p>
                                            </div>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                    <?php if($wishlist->count() == 0): ?>
                        <div class="row bg-white radius-10 mx-2">
                            <div class="com-md-12">
                                <?php echo $__env->make('frontend.default.empty', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Pagination -->
        <?php if(count($wishlist) > 0): ?>
            <div class="entry-pagination">
                <nav aria-label="Page navigation example">
                    <?php echo e($wishlist->links()); ?>

                </nav>
            </div>
        <?php endif; ?>
        <!-- Pagination -->
        </div>
    </section>
    <!------------ My wishlist area End  ------------>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>

<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.default', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/palsarh/web/palsarh.in/public_html/resources/views/frontend/default/student/wishlist/index.blade.php ENDPATH**/ ?>