@extends('layouts.' . get_frontend_settings('theme'))
@push('title', get_phrase('Register Now'))
@push('meta')@endpush
@push('css')
    <style>
        .form-icons .right {
            right: 20px;
            cursor: pointer !important;
        }
    </style>
@endpush
@section('content')
    <section class="login-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-7 col-md-6" style="display: none;">
                    <div class="login-img">
                        <img src="{{ asset('assets/frontend/' . get_frontend_settings('theme') . '/image/signup.gif') }}" alt="register-banner">
                    </div>
                </div>
                <div class="col-lg-6 col-md-6" style="margin: 0 auto;">
                    @if(session('success'))
                      <div class="alert alert-success">
                        {{ session('success') }}
                      </div>
                    @endif
                    <form action="{{ route('registration') }}" class="global-form row login-form mt-25" method="post">
                    @csrf
                        <h5 class="g-title">{{ get_phrase('ONLINE STATE LEVEL EXAM FOR ADVOCATES') }}</h5>
                        <p class="description" style="margin: 5px;">{{ get_phrase('Based on the Book:') }}</p>
                        <p class="description" style="margin: 5px;">"The Science, Craft and Art of Trial Court Advocacy."</p>
                         <p class="description" style="margin: 5px;">A Step-by-Step Guide to Trial Excellence (Smemi-Telugu Version)</p>
                        <div class="col-sm-12 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('Name of Candidate') }}</label>
                            <input type="text" name="name" class="form-control" placeholder="Your Name">
                            @error('name')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                        <div class="col-sm-12 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('TS Enrollment Number') }}</label>
                            <input type="text" name="enrollment_number" class="form-control" placeholder="Your Enrollment Number">
                            @error('enrollment_number')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                        <div class="col-sm-12 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('Place of Practice') }}</label>
                            <input type="text" name="place_practice" class="form-control" placeholder="Place of Practice">
                            @error('place_practice')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                        <div class="col-sm-12 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('Years of Practice') }}</label>
                            <input type="text" name="practice_period" class="form-control" placeholder="Years of Practice">
                            @error('practice_period')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                        <div class="col-sm-6 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('Email') }}</label>
                            <input type="email" name="email" class="form-control" placeholder="Your Email">
                            @error('email')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
						<div class="col-sm-6 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('Phone') }}</label>
                            <input type="text" name="phone" class="form-control" placeholder="Your Phone">
                            @error('phone')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
						
                        <div class="col-sm-12 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('Password') }}</label>
                            <input type="password" name="password" class="form-control" placeholder="*********">

                            @error('password')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
						<div class="col-sm-12 text-center">
							<button type="submit" class="eBtn gradient w-100">{{ get_phrase('Register Now') }}</button>
						</div>
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection
@push('js')
    <script>
        "use strict";

        $(document).ready(function() {
            $('#showpassword').on('click', function(e) {
                e.preventDefault();
                const type = $('#password').attr('type');

                if (type == 'password') {
                    $('#password').attr('type', 'text');
                } else {
                    $('#password').attr('type', 'password');
                }
            });
        });

        $(document).ready(function() {
            $('#showcpassword').on('click', function(e) {
                e.preventDefault();
                const type = $('#cpassword').attr('type');

                if (type == 'password') {
                    $('#cpassword').attr('type', 'text');
                } else {
                    $('#cpassword').attr('type', 'password');
                }
            });
        });
    </script>
@endpush
