@extends('layouts.' . get_frontend_settings('theme'))
@push('title', get_phrase('Register Now'))
@push('meta')@endpush
@push('css')
    <style>
        .form-icons .right {
            right: 20px;
            cursor: pointer !important;
        }
    </style>
@endpush
@section('content')
    <section class="login-area">
        <div class="container">
            <div class="row">
                <div class="col-lg-7 col-md-6" style="display: none;">
                    <div class="login-img">
                        <img src="{{ asset('assets/frontend/' . get_frontend_settings('theme') . '/image/signup.gif') }}" alt="register-banner">
                    </div>
                </div>
                <div class="col-lg-6 col-md-6" style="margin: 0 auto;">
                    <form action="{{ route('register') }}" class="global-form row login-form mt-25" method="post">@csrf
                        <h4 class="g-title">{{ get_phrase('Register Now') }}</h4>
                        <p class="description">{{ get_phrase('See your growth and get consulting support! ') }}</p>
                        <div class="col-sm-12 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('Name') }}</label>
                            <input type="text" name="name" class="form-control" placeholder="Your Name">
                            @error('name')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                        <div class="col-sm-6 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('Email') }}</label>
                            <input type="email" name="email" class="form-control" placeholder="Your Email">
                            @error('email')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
						<div class="col-sm-6 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('Phone') }}</label>
                            <input type="text" name="phone" class="form-control" placeholder="Your Phone">
                            @error('phone')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
						
						<div class="col-sm-6 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('Date of birth') }}</label>
                            <input type="date" name="date_of_birth" class="form-control" placeholder="Your Date of birth">
                            @error('date_of_birth')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
						<div class="col-sm-6 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('Category') }}</label>
                            <input type="text" name="category" class="form-control" placeholder="Enter Category">
                            @error('category')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
						
						
						<div class="col-sm-6 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('Father/ Gaurdian name') }}</label>
                            <input type="text" name="father_name" class="form-control" placeholder="Your Father/ Gaurdian name">
                            @error('father_name')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
						<div class="col-sm-6 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('Gaurdian mobile number') }}</label>
                            <input type="text" name="father_phone" class="form-control" placeholder="Your Gaurdian mobile number">
                            @error('father_phone')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
						
						
						<div class="col-sm-12 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('Your postal address') }}</label>
                            <input type="text" name="postal_address" class="form-control" placeholder="Your postal address">
                            @error('postal_address')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
						
						
						
						<div class="col-sm-12 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('Name of the Law College') }}</label>
                            <input type="text" name="law_college" class="form-control" placeholder="Enter Name of the Law College">
                            @error('law_college')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
						
                        <div class="col-sm-12 form-group mb-5">
                            <label for="" class="form-label">{{ get_phrase('Password') }}</label>
                            <input type="password" name="password" class="form-control" placeholder="*********">

                            @error('password')
                                <small class="text-danger">{{ $message }}</small>
                            @enderror
                        </div>
						<div class="col-sm-12 text-center">
							<button type="submit" class="eBtn gradient w-100">{{ get_phrase('Register Now') }}</button>
							<p class="mt-20">{{ get_phrase('Already have account.') }} <a href="{{ route('login') }}">{{ get_phrase('Sign in') }}</a></p>
						</div>
                    </form>
                </div>
            </div>
        </div>
    </section>
@endsection
@push('js')
    <script>
        "use strict";

        $(document).ready(function() {
            $('#showpassword').on('click', function(e) {
                e.preventDefault();
                const type = $('#password').attr('type');

                if (type == 'password') {
                    $('#password').attr('type', 'text');
                } else {
                    $('#password').attr('type', 'password');
                }
            });
        });

        $(document).ready(function() {
            $('#showcpassword').on('click', function(e) {
                e.preventDefault();
                const type = $('#cpassword').attr('type');

                if (type == 'password') {
                    $('#cpassword').attr('type', 'text');
                } else {
                    $('#cpassword').attr('type', 'password');
                }
            });
        });
    </script>
@endpush
