<?PHP

$students = App\Models\User::where("role","student")->get();
$courses = App\Models\Course::where("status","active")->get();

?>


<div class="ol-card">
    <div class="ol-card-body">
        <form action="{{ route('admin.notification.store') }}" method="post" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <div class="fpb-7 mb-3">
                    <label class="form-label ol-form-label" for="title">{{ get_phrase('Title') }}</label>
                    <input type="text" class="form-control ol-form-control" name="title" id="title"
                        placeholder="{{ get_phrase('Enter Title') }}" required>
                </div>

                <div class="fpb-7 mb-3">
                    <label class="form-label ol-form-label" for="message">{{ get_phrase('Message') }}</label>
                    <input type="text" class="form-control ol-form-control" name="message" id="message"
                        placeholder="{{ get_phrase('Enter Message') }}" required>
                </div>

                <div class="fpb-7 mb-3">
                    <label class="form-label ol-form-label" for="status">{{ get_phrase('Send Message to') }}</label>
                    <select for='status' class="form-control ol-form-control ol-select2"
                        name="status" id="status" required>
                        <option value="">{{ get_phrase('Choose Message to ...') }}</option>
                        <option value="course">{{ get_phrase('Course') }}</option>
                        <option value="student">{{ get_phrase('Student') }}</option>
                    </select>
                </div>
				
				<div class="fpb-7 mb-3">
                    <label class="form-label ol-form-label" for="status">{{ get_phrase('Status') }}</label>
                    <select for='status' class="form-control ol-form-control ol-select2"
                        name="status" id="status" required>
                        <option value="">{{ get_phrase('Choose status ...') }}</option>
                        @foreach($courses as $key => $course)
                        <option value="{{ $course->id }}">{{ $course->title }}</option>
						@endforeach
                    </select>
                </div>

                <div class="fpb-7 mb-3">
                    <label class="form-label ol-form-label" for="student_id">{{ get_phrase('Student') }}</label>
                    <select for='student_id' class="form-control ol-form-control ol-select2"
                        name="student_id" id="student_id" required>
                        <option value="">{{ get_phrase('Choose Student ...') }}</option>
						@foreach($students as $key => $student)
                        <option value="{{ $student->id }}">{{ $student->name }} - {{ $student->email }}</option>
						@endforeach
                    </select>
                </div>
            </div>

            <div class="fpb-7 mb-2 d-flex justify-content-end">
                <button type="submit" class="ol-btn-primary">{{ get_phrase('Send Notifications') }}</button>
            </div>
        </form>
    </div>
</div>
