@extends('layouts.admin')
@push('title', get_phrase('Notifications'))
@push('meta')@endpush
@push('css')@endpush
@section('content')
    <!-- Mani section header and breadcrumb -->
    <div class="ol-card radius-8px">
        <div class="ol-card-body my-3 py-12px px-20px">
            <div class="d-flex align-items-center justify-content-between gap-3 flex-wrap flex-md-nowrap">
                <h4 class="title fs-16px">
                    <i class="fi-rr-settings-sliders me-2"></i>
                    <span>{{ get_phrase('Notifications') }}</span>
                </h4>                
            </div>
        </div>
    </div>

    <!-- Start Admin area -->
    <div class="row">
        <div class="col-12">
            <div class="ol-card">
                <div class="ol-card-body p-3">
                    <div class="row print-d-none mb-3 mt-3 row-gap-3">
                        <div class="col-md-12 pt-2 pt-md-0">
                            <div class="ol-card">
    <div class="ol-card-body">
        <form action="{{ route('admin.notification.store') }}" method="post" enctype="multipart/form-data">
            @csrf
            <div class="row">
                <div class="col-sm-4 fpb-7 mb-3">
                    <label class="form-label ol-form-label" for="title">{{ get_phrase('Title') }}</label>
                    <input type="text" class="form-control ol-form-control" name="title" id="title"
                        placeholder="{{ get_phrase('Enter Title') }}" required>
                </div>

                <div class="col-sm-4 fpb-7 mb-3">
                    <label class="form-label ol-form-label" for="message">{{ get_phrase('Message') }}</label>
                    <input type="text" class="form-control ol-form-control" name="message" id="message"
                        placeholder="{{ get_phrase('Enter Message') }}" required>
                </div>

                <div class="col-sm-4 fpb-7 mb-3">
                    <label class="form-label ol-form-label" for="type">{{ get_phrase('Send Message to') }}</label>
                    <select for='type' class="form-control ol-form-control ol-select2" name="type" id="type" required>
                        <option value="">{{ get_phrase('Choose Message to ...') }}</option>
                        <option value="course">{{ get_phrase('Course') }}</option>
                        <option value="student">{{ get_phrase('Student') }}</option>
                    </select>
                </div>
				
				<div id="course" class="ssblock col-sm-4 fpb-7 mb-3" style="display: none;">
                    <label class="form-label ol-form-label" for="course_id">{{ get_phrase('Course') }}</label>
                    <select for='course_id' class="form-control ol-form-control ol-select2"
                        name="course_id" id="course_id">
                        <option value="">{{ get_phrase('Choose status ...') }}</option>
                        @foreach($courses as $key => $course)
                        <option value="{{ $course->id }}">{{ $course->title }}</option>
						@endforeach
                    </select>
                </div>

                <div id="student" class="ssblock col-sm-4 fpb-7 mb-3" style="display: none;">
                    <label class="form-label ol-form-label" for="student_id">{{ get_phrase('Student') }}</label>
                    <select for='student_id' class="form-control ol-form-control ol-select2"
                        name="student_id" id="student_id">
                        <option value="">{{ get_phrase('Choose Student ...') }}</option>
						@foreach($students as $key => $student)
                        <option value="{{ $student->id }}">{{ $student->name }} - {{ $student->email }}</option>
						@endforeach
                    </select>
                </div>
            </div>

            <div class="fpb-7 mb-2 d-flex justify-content-end">
                <button type="submit" class="ol-btn-primary">{{ get_phrase('Send Notifications') }}</button>
            </div>
        </form>
    </div>
</div>
                        </div>
						<div class="col-md-12 mt-3 mb-3 mt-md-0"><hr/></div>
                        <div class="col-md-12 mt-3 mt-md-0">
                            <form action="{{ route('admin.notifications') }}" method="get" class="d-flex gap-3 justify-content-end">
                                <div class="search-input flex-grow-1">
                                    <input type="text" name="search" value="{{ request('search') }}" placeholder="{{ get_phrase('Search Notification') }}" class="ol-form-control form-control" />

                                </div>
                                <button type="submit" class="btn ol-btn-primary" id="submit-button">{{ get_phrase('Search') }}</button>
                            </form>
                        </div>
                    </div>
                    <!-- Table -->
                    @if (count($notifications) > 0)
                        <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                            <p class="admin-tInfo">
                                {{ get_phrase('Showing') . ' ' . count($notifications) . ' ' . get_phrase('of') . ' ' . $notifications->total() . ' ' . get_phrase('data') }}
                            </p>
                        </div>
                        <div class="table-responsive course_list" id="course_list">
                            <table class="table eTable eTable-2 print-table">
                                <thead>
                                    <tr>
                                        <th scope="col">#</th>
                                        <th scope="col">{{ get_phrase('Title') }}</th>
                                        <th scope="col">{{ get_phrase('Course') }}</th>
                                        <th scope="col">{{ get_phrase('Student') }}</th>
                                        <th scope="col" class="print-d-none">{{ get_phrase('Options') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($notifications as $key => $notification)
                                        <tr>
                                            <th scope="row">
                                                <p class="row-number">{{ ++$key }}</p>
                                            </th>

                                            <td>
                                                <div class="dAdmin_profile d-flex align-items-center min-w-200px">
                                                    <div class="dAdmin_profile_name">
                                                        <h4 class="title fs-14px">{{ $notification->title }}</h4>
                                                    </div>
                                                </div>
                                            </td>

                                            <td>
                                                <div class="dAdmin_info_name min-w-150px">
                                                    <p>
														@if($notification->course_id != "")
														<?PHP  $course = App\Models\Course::find($notification->course_id); ?>
															{{ $course->title }}
														@else
															-
														@endif
                                                    </p>
                                                </div>
                                            </td>
											
											<td>
                                                <div class="dAdmin_info_name min-w-150px">
                                                    <p>
                                                        @if($notification->student_id != "")
														<?PHP  $user = App\Models\User::find($notification->student_id); ?>
															{{ $user->name }} | {{ $user->email }}
														@else
															-
														@endif
                                                    </p>
                                                </div>
                                            </td>

                                            <td class="print-d-none">
                                                <div class="dropdown ol-icon-dropdown ol-icon-dropdown-transparent">
                                                    <button class="btn ol-btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                                                        <span class="fi-rr-menu-dots-vertical"></span>
                                                    </button>
                                                    <ul class="dropdown-menu">
                                                        <li><a class="dropdown-item" href="javascript:void(0);" onclick="confirmModal('{{ route('admin.notification.delete', $notification->id) }}')">{{ get_phrase('Delete') }}</a></li>
                                                    </ul>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        @include('admin.no_data')
                    @endif
                    <!-- Data info and Pagination -->
                    @if (count($notifications) > 0)
                        <div class="admin-tInfo-pagi d-flex justify-content-between justify-content-center align-items-center flex-wrap gr-15">
                            <p class="admin-tInfo">
                                {{ get_phrase('Showing') . ' ' . count($notifications) . ' ' . get_phrase('of') . ' ' . $notifications->total() . ' ' . get_phrase('data') }}
                            </p>
                            {{ $notifications->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <!-- End Admin area -->
@endsection
@push('js')
<script type="text/javascript">
	$(document).ready(function(){
		$('#type').on("change",function(){
			$('.ssblock').hide();
			$('#'+$(this).val()).show();
		});
	});
</script>
@endpush
