<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\CartItem;
use App\Providers\RouteServiceProvider;
use Carbon\Carbon;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rules;
use Illuminate\View\View;
use Illuminate\Support\Facades\Session;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     */
    public function create(): View
    {
        $view = view('auth.register');
		//$view->course = Session::get('course_id');
		return $view;
    }

    /**
     * Handle an incoming registration request.
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request): RedirectResponse
    {

        $validator = Validator::make($request->all(), [
            'name' => ['required', 'string', 'max:255'],
			'date_of_birth' => ['required', 'string', 'max:255'],
			'father_name' => ['required', 'string', 'max:255'],
			'father_phone' => ['required', 'string', 'max:255'],
			'postal_address' => ['required', 'string', 'max:255'],
			'category' => ['required', 'string', 'max:255'],
			'law_college' => ['required', 'string', 'max:255'],
			'phone' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'unique:users,email'],
            'password' => ['required', Rules\Password::defaults()],
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        $user_data = [
            'name' => $request->name,
            'email' => $request->email,
			'phone' => $request->phone,
			
			'date_of_birth' => $request->date_of_birth,
            'father_name' => $request->father_name,
			'father_phone' => $request->father_phone,
			'postal_address' => $request->postal_address,
            'category' => $request->category,
			'law_college' => $request->law_college,
			
            'role' => 'student',
            'status' => 1,
            'password' => Hash::make($request->password),
        ];

        if(get_settings('student_email_verification') == 1){
            $user_data['email_verified_at'] = Carbon::now();
        }

        $user = User::create($user_data);


        //event(new Registered($user));

        Auth::login($user);
		/*
		$course_id = 5;
		if($course_id){
			$query = CartItem::where('course_id', $course_id)->where('user_id', auth()->user()->id);
            if ($query->count() == 0) {
                CartItem::insert(['user_id' => auth()->user()->id, 'course_id' => $course_id, 'created_at' => date('Y-m-d H:i:s')]);
                return redirect(route('cart'));
            } elseif ($query->count() == 1) {
                return redirect(route('cart'));
            }
		}
		*/
        return redirect(RouteServiceProvider::HOME);
    }
}
